<?php
header("Access-Control-Allow-Methods: GET, POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $body = file_get_contents("php://input");
    $datos = json_decode($body, true);

    if (!isset($datos[0]) || empty($datos[0])) {
        throw new Exception("Filtro no proporcionado.");
    }

    $filtro = $datos[0];

    $sql = "SELECT * FROM informe_creditos_cobrar(:filtro);";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtro', $filtro, PDO::PARAM_STR);
    $stmt->execute();
    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($resultados, JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["error" => "Error en la base de datos: " . $e->getMessage()]);
}
?>
