<?php
error_reporting(E_ALL ^ E_NOTICE);
ini_set('display_errors', 1);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        throw new Exception("Error al decodificar JSON: " . json_last_error_msg());
    }

    if (!isset($datos['filtroTurno'])) {
        throw new Exception("Parámetro 'filtroTurno' requerido.");
    }

    $filtroTurno = $datos['filtroTurno'];

    $sql = "SELECT * FROM vista_despachos_turno " . $filtro;
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':filtroTurno', $filtroTurno, PDO::PARAM_STR);
    $stmt->execute();

    $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($resultado, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en la API: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
