<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
// Decodifica el cuerpo de la solicitud y lo guarda en un array de PHP
$datos = json_decode($bodyRequest, true);

$rows = array();
$sql = "SELECT K.producto_id, K.codigo_producto, P.nombre AS descripcion, K.fecha_traslado, If(K.entrada>0,'E','S') AS tipo,
        If(K.entrada>0,'02','01') AS tipo10, DF.codigo_sunat AS tipo12, K.entrada, TRUNCATE((K.entrada/P.capacidad),0) AS Ent_Und,
        If(K.capacidad_precio=P.capacidad,K.unidad_medida,'') AS AbreE_Und, (K.entrada-TRUNCATE((K.entrada/P.capacidad),0)*P.capacidad) AS Ent_Fra,
        If(K.capacidad_precio<P.capacidad,K.unidad_medida,'') AS AbreE_Fra, K.costo,
        K.salida, TRUNCATE((K.salida/P.capacidad),0) AS Vta_Und, If(K.capacidad_precio=P.capacidad,K.unidad_medida,'') AS AbreV_Und,
        (K.salida-TRUNCATE((K.salida/P.capacidad),0)*P.capacidad) AS Vta_Fra, If(K.capacidad_precio<P.capacidad,K.unidad_medida,'') AS AbreV_Fra, K.precio_venta,
        K.nserie, K.ndocumento, P.capacidad from kardex AS K 
        INNER JOIN productos AS P ON K.producto_id = P.id 
        INNER JOIN docfiscales AS DF ON K.docfiscal_id = DF.id
        WHERE {$datos[0]} AND K.producto_id = $datos[1] ORDER BY K.producto_id, K.fecha_traslado, Entrada Desc";

/*print_r("Filtro",'$datos[0]')*/

if ($result = mysqli_query($conn, $sql)) {
    if (mysqli_num_rows($result) > 0) {
        while ($row = mysqli_fetch_assoc($result)) {
            $rows[] = $row;
        }
        mysqli_free_result($result);
    } else {
        //echo "No records matching your query were found.";
        print_json([]);
    }
} else {
    echo "ERROR: Could not able to execute the query."; // . mysqli_error($this->conn);
}

// Cerrar la conexi�0�5�6�0n a la base de datos
mysqli_close($conn);

// Imprimir la respuesta en formato JSON
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
