<?php
include_once '../conexion.php';
header('Content-Type: application/json; charset=utf-8');

try {
    $pdo = isset($pdo) ? $pdo : (isset($conn) ? $conn : null);
    if (!($pdo instanceof PDO)) throw new Exception('Conexión inválida: se esperaba un PDO.');
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $data = json_decode(file_get_contents('php://input'), true);
    if (!$data) { echo json_encode(['ESTADO'=>'11','ID'=>0,'MENSAJE'=>'JSON inválido']); exit; }

    $cFecha        = $data['Fecha']        ?? date('Y-m-d');
    $cNombre       = $data['Nombre']       ?? '';
    $cDireccion    = $data['Direccion']    ?? '';
    $cDocIdentidad = $data['DocIdentidad'] ?? '';
    $cMoneda       = $data['Moneda']       ?? '01';
    $cTipoCambio   = (float)($data['Tipo_Cambio'] ?? 0);
    $cProveedor_Id = (int)($data['Proveedor_Id'] ?? 0);
    $cSucursal_Id  = (int)($data['Sucursal_Id'] ?? 0);
    $cEmpresa_Id   = (int)($data['Empresa_Id'] ?? 0);
    $cUsuario_Id   = (int)($data['Usuario_Id'] ?? 0);

    $creditos_canjeados = $data['creditos_canjeados'] ?? [];
    $detalle            = $data['detalle'] ?? [];

    if ($cProveedor_Id <= 0 || $cEmpresa_Id <= 0 || $cSucursal_Id <= 0) {
        echo json_encode(['ESTADO'=>'11','ID'=>0,'MENSAJE'=>'Faltan parámetros: Proveedor/Empresa/Sucursal']); exit;
    }

    $pdo->beginTransaction();

    // 1) CABECERA
    $driver = $pdo->getAttribute(PDO::ATTR_DRIVER_NAME);
    $sqlCab = "INSERT INTO canje_letrasxpagar
               (fecha, moneda, tipo_cambio, proveedor_id, sucursal_id, empresa_id, usuario_id)
               VALUES (:fecha, :moneda, :tc, :prov, :suc, :emp, :usr)";
    if ($driver === 'pgsql') $sqlCab .= " RETURNING id";

    $stmtCab = $pdo->prepare($sqlCab);
    $stmtCab->execute([
        ':fecha'=>$cFecha, ':moneda'=>$cMoneda, ':tc'=>$cTipoCambio, ':prov'=>$cProveedor_Id,
        ':suc'=>$cSucursal_Id, ':emp'=>$cEmpresa_Id, ':usr'=>$cUsuario_Id
    ]);
    $idMovLetra = ($driver === 'pgsql') ? (int)$stmtCab->fetchColumn() : (int)$pdo->lastInsertId();

    // 2) MARCAR FACTURAS (intento por id / compra / serie+numero)
    $actualizados = 0;

    $stmtUpdById = $pdo->prepare(
        "UPDATE creditos_pagar
         SET canjeado = TRUE, letra_id = :letra_id
         WHERE id = :id
           AND COALESCE(anulado,FALSE) = FALSE
           AND COALESCE(letra,FALSE)   = FALSE"
    );
    $stmtUpdByCompra = $pdo->prepare(
        "UPDATE creditos_pagar
         SET canjeado = TRUE, letra_id = :letra_id
         WHERE compra_id = :compra
           AND empresa_id = :emp AND sucursal_id = :suc AND proveedor_id = :prov
           AND COALESCE(anulado,FALSE) = FALSE
           AND COALESCE(letra,FALSE)   = FALSE"
    );
    $stmtUpdBySerDoc = $pdo->prepare(
        "UPDATE creditos_pagar
         SET canjeado = TRUE, letra_id = :letra_id
         WHERE nserie = :nserie AND ndocumento = :ndoc
           AND empresa_id = :emp AND sucursal_id = :suc AND proveedor_id = :prov
           AND COALESCE(anulado,FALSE) = FALSE
           AND COALESCE(letra,FALSE)   = FALSE"
    );

    foreach ($creditos_canjeados as $it) {
        $idCredito  = (int)($it['id'] ?? 0);
        $compra_id  = (int)($it['compra_id'] ?? 0);
        $nserie     = trim($it['nserie'] ?? ($it['serie'] ?? ''));
        $ndocumento = trim($it['ndocumento'] ?? ($it['numero'] ?? ''));

        $rows = 0;
        if ($idCredito > 0) {
            $stmtUpdById->execute([':letra_id'=>$idMovLetra, ':id'=>$idCredito]);
            $rows = $stmtUpdById->rowCount();
        }
        if ($rows === 0 && $compra_id > 0) {
            $stmtUpdByCompra->execute([
                ':letra_id'=>$idMovLetra, ':compra'=>$compra_id,
                ':emp'=>$cEmpresa_Id, ':suc'=>$cSucursal_Id, ':prov'=>$cProveedor_Id
            ]);
            $rows = $stmtUpdByCompra->rowCount();
        }
        if ($rows === 0 && $nserie !== '' && $ndocumento !== '') {
            $stmtUpdBySerDoc->execute([
                ':letra_id'=>$idMovLetra, ':nserie'=>$nserie, ':ndoc'=>$ndocumento,
                ':emp'=>$cEmpresa_Id, ':suc'=>$cSucursal_Id, ':prov'=>$cProveedor_Id
            ]);
            $rows = $stmtUpdBySerDoc->rowCount();
        }

        $actualizados += $rows;
    }

    // 3) INSERT DE LETRAS
    $insertados = 0;
    if (!empty($detalle)) {
        $stmtDet = $pdo->prepare(
            "INSERT INTO creditos_pagar
             (nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento,
              documento_identidad, razon_social, direccion,
              deuda_soles, deuda_dolar, moneda, tipo_cambio,
              proveedor_id, compra_id, sucursal_id, empresa_id,
              letra, canjeado, letra_id)
             VALUES
             (:nserie, :ndocumento, :nro_letra, :nro_unico, :fecha, :fecha_venc,
              :doc, :razon, :dir,
              :deuda_s, :deuda_d, :moneda, :tc,
              :prov, :compra, :suc, :emp,
              TRUE, FALSE, :letra_id)"
        );

        foreach ($detalle as $d) {
            $stmtDet->execute([
                ':nserie'     => $d['nserie'] ?? '',
                ':ndocumento' => $d['ndocumento'] ?? '',
                ':nro_letra'  => $d['nro_letra'] ?? '',
                ':nro_unico'  => $d['nro_unico'] ?? '',
                ':fecha'      => $d['fecha'] ?? $cFecha,
                ':fecha_venc' => $d['fecha_vencimiento'] ?? $cFecha,
                ':doc'        => $cDocIdentidad,
                ':razon'      => $cNombre,
                ':dir'        => $cDireccion,
                ':deuda_s'    => (float)($d['deuda_soles'] ?? 0),
                ':deuda_d'    => (float)($d['deuda_dolar'] ?? 0),
                ':moneda'     => $cMoneda,
                ':tc'         => $cTipoCambio,
                ':prov'       => $cProveedor_Id,
                ':compra'     => (int)($d['compra_id'] ?? 0),
                ':suc'        => $cSucursal_Id,
                ':emp'        => $cEmpresa_Id,
                ':letra_id'   => $idMovLetra
            ]);
            $insertados += $stmtDet->rowCount();
        }
    }

    // 4) RESCATE POR compra_id (por si arriba no actualizó)
    $compraIds = [];
    foreach ($creditos_canjeados as $cc) {
        $x = (int)($cc['compra_id'] ?? 0);
        if ($x > 0) $compraIds[$x] = true;
    }
    foreach ($detalle as $dd) {
        $x = (int)($dd['compra_id'] ?? 0);
        if ($x > 0) $compraIds[$x] = true;
    }
    $compraIds = array_keys($compraIds);

    if (!empty($compraIds)) {
        // UPDATE ... WHERE compra_id IN (...)
        $place = implode(',', array_fill(0, count($compraIds), '?'));
        $sqlRescate =
            "UPDATE creditos_pagar
             SET canjeado = TRUE, letra_id = ?
             WHERE compra_id IN ($place)
               AND COALESCE(letra,FALSE)   = FALSE
               AND COALESCE(anulado,FALSE) = FALSE";
        $stmtRes = $pdo->prepare($sqlRescate);
        $params  = array_merge([$idMovLetra], $compraIds);
        $stmtRes->execute($params);
        $actualizados += $stmtRes->rowCount();
    }

    $pdo->commit();

    echo json_encode([
        'ESTADO'       => '00',
        'ID'           => $idMovLetra,
        'ACTUALIZADOS' => $actualizados,
        'INSERTADOS'   => $insertados,
        'MENSAJE'      => 'Canje registrado correctamente'
    ]);
} catch (Throwable $e) {
    if (isset($pdo) && $pdo instanceof PDO) {  // ← corregido (un paréntesis menos)
        try {
            if ($pdo->inTransaction()) {
                $pdo->rollBack();
            }
        } catch (Throwable $ignored) {}
    }

    echo json_encode([
        'ESTADO'  => '11',
        'ID'      => 0,
        'MENSAJE' => 'Error: ' . $e->getMessage()
    ]);
}