<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Obtener parámetros del body
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar parámetros requeridos
if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
    http_response_code(400);
    echo json_encode(['error' => 'Parámetros incompletos']);
    exit;
}

$idempresa    = (int)$datos[0];
$idsucursal   = (int)$datos[1];
$proveedor_id = (int)$datos[2];
$canjeado     = filter_var($datos[3], FILTER_VALIDATE_BOOLEAN); // true/false

try {
    $stmt = $conn->prepare("SELECT * FROM listar_credxpag_canjear(:idempresa, :idsucursal, :proveedor_id, :canjeado)");
    $stmt->bindParam(':idempresa', $idempresa, PDO::PARAM_INT);
    $stmt->bindParam(':idsucursal', $idsucursal, PDO::PARAM_INT);
    $stmt->bindParam(':proveedor_id', $proveedor_id, PDO::PARAM_INT);
    $stmt->bindParam(':canjeado', $canjeado, PDO::PARAM_BOOL);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Error en la consulta: ' . $e->getMessage()]);
}
