<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header('Content-Type: application/json; charset=utf-8');

require_once '../conexion.php';

// Llama la validación antes de cualquier consulta
//$usuarioId = TokenValidator::validar($conn);

// Obtener parámetros del body
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$body = json_decode(file_get_contents('php://input'), true);
if (!$body) { echo json_encode(['ESTADO'=>'11','ID'=>0,'MENSAJE'=>'JSON inválido']); exit; }

try {
    $pdo->beginTransaction();

    $fecha        = $body['Fecha'] ?? date('Y-m-d');
    $docId        = $body['DocIdentidad'] ?? '';
    $nombre       = $body['Nombre'] ?? '';
    $direccion    = $body['Direccion'] ?? '';
    $moneda       = $body['Moneda'] ?? '01';
    $tc           = (float)($body['Tipo_Cambio'] ?? 0);
    $proveedor_id = (int)($body['Proveedor_Id'] ?? 0);
    $sucursal_id  = (int)($body['Sucursal_Id'] ?? 0);
    $empresa_id   = (int)($body['Empresa_Id'] ?? 0);
    $usuario_id   = (int)($body['Usuario_Id'] ?? 0);
    $detalle      = $body['detalle'] ?? [];
    $canjeados    = $body['creditos_canjeados'] ?? [];

    // 1) cabezera canje_letrasxpagar (RETURNING id)
    $stmt = $pdo->prepare("
        INSERT INTO public.canje_letrasxpagar (fecha, moneda, tipo_cambio, proveedor_id, sucursal_id, empresa_id, usuario_id)
        VALUES (:fecha, :moneda, :tc, :proveedor_id, :sucursal_id, :empresa_id, :usuario_id)
        RETURNING id
    ");
    $stmt->execute([
        ':fecha'=>$fecha, ':moneda'=>$moneda, ':tc'=>$tc,
        ':proveedor_id'=>$proveedor_id, ':sucursal_id'=>$sucursal_id,
        ':empresa_id'=>$empresa_id, ':usuario_id'=>$usuario_id
    ]);
    $idMovLetra = (int)$stmt->fetchColumn();

    // 2) marcar créditos canjeados
    if (!empty($canjeados)) {
        $upd = $pdo->prepare("
            UPDATE public.creditos_pagar
               SET canjeado = TRUE, letra = TRUE, letra_id = :letra_id
             WHERE proveedor_id = :proveedor_id
               AND compra_id    = :compra_id
        ");
        foreach ($canjeados as $c) {
            $upd->execute([
                ':letra_id'=>$idMovLetra,
                ':proveedor_id'=>$proveedor_id,
                ':compra_id'=>(int)$c['compra_id']
            ]);
        }
    }

    // 3) insertar nuevas letras como créditos por pagar
    $ins = $pdo->prepare("
        INSERT INTO public.creditos_pagar
            (nserie, ndocumento, nro_letra, nro_unico, fecha, fecha_vencimiento,
             documento_identidad, razon_social, direccion,
             deuda_soles, deuda_dolar, moneda, tipo_cambio,
             proveedor_id, compra_id, sucursal_id, empresa_id, letra, letra_id, canjeado)
        VALUES
            (:nserie, :ndocumento, :nro_letra, :nro_unico, :fecha, :fecha_vencimiento,
             :docid, :razon, :dir,
             :deuda_soles, :deuda_dolar, :moneda, :tc,
             :proveedor_id, :compra_id, :sucursal_id, :empresa_id, TRUE, :letra_id, TRUE)
    ");

    foreach ($detalle as $d) {
        $ins->execute([
            ':nserie'           => $d['nserie'] ?? '',
            ':ndocumento'       => $d['ndocumento'] ?? '',
            // ✅ corrección: usar nro_letra / nro_unico del JSON, no repetir serie/documento
            ':nro_letra'        => $d['nro_letra'] ?? '',
            ':nro_unico'        => $d['nro_unico'] ?? '',
            ':fecha'            => $d['fecha'] ?? $fecha,
            ':fecha_vencimiento'=> $d['fecha_vencimiento'] ?? $fecha,
            ':docid'            => $docId,
            ':razon'            => $nombre,
            ':dir'              => $direccion,
            ':deuda_soles'      => isset($d['deuda_soles']) ? (float)$d['deuda_soles'] : 0,
            ':deuda_dolar'      => isset($d['deuda_dolar']) ? (float)$d['deuda_dolar'] : 0,
            ':moneda'           => $moneda,
            ':tc'               => $tc,
            ':proveedor_id'     => $proveedor_id,
            ':compra_id'        => (int)($d['compra_id'] ?? 0),
            ':sucursal_id'      => $sucursal_id,
            ':empresa_id'       => $empresa_id,
            ':letra_id'         => $idMovLetra
        ]);
    }

    $pdo->commit();
    echo json_encode(['ESTADO'=>'00','ID'=>$idMovLetra,'MENSAJE'=>'Los datos se han guardado correctamente']);
} catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    echo json_encode(['ESTADO'=>'11','ID'=>0,'MENSAJE'=>'Error al guardar: '.$e->getMessage()]);
}
