<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if ($data === null) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'");
    }

    foreach (['detalle', 'series'] as $arr) {
        if (!isset($data[$arr]) || !is_array($data[$arr])) {
            throw new Exception("El campo '$arr' debe ser un array.");
        }
    }

    $conn->beginTransaction();

    $sql = "SELECT procesar_ordenalmacen(
        :p_empresa_id, :p_docfiscal_id, :p_operacion_id, :p_motivoguia_id, :p_nserie, :p_ndocumento,
        :p_fecha_emision, :p_fecha_traslado, :p_direccion_partida, :p_ubigeo_partida,
        :p_tipodoc_cliente, :p_ndoc_cliente, :p_razonsocial, :p_direccion_llegada,
        :p_ubigeo_llegada, :p_placa, :p_placa2, :p_marca, :p_nroinscripcion,
        :p_dniconductor, :p_nombreconductor, :p_licencia, :p_tipodoc_transportista,
        :p_ndoc_transportista, :p_nombre_transportista,
        :p_afecto_igv, :p_pigv, :p_igv, :p_afecto, :p_inafecto,
        :p_exonerado, :p_total, :p_afecta_kardex, :p_tipodestinatario_id, :p_cliente_id, :p_unidadtransp_id,
        :p_conductor_id, :p_transportista_id, :p_trasladado,
        :p_sededestino_id, :p_almdestino_id, :p_sucursal_id, :p_almacen_id, :p_observacion,
        :p_idorden, :p_estado, :p_detalle, :p_series
    ) AS idordenalmacen";

    $stmt = $conn->prepare($sql);

    $campos = [
        'Empresa_id', 'DocFiscal_Id', 'Operacion_Id', 'MotivoGuia_Id', 'NSerie', 'NDocumento',
        'Fecha_Emision', 'Fecha_Traslado', 'Direccion_Partida', 'Ubigeo_Partida',
        'Tipo_DocIdentDest', 'DocIdentidad', 'Razon_Social', 'Direccion_Destino',
        'Ubigeo_Destino', 'Placa', 'Placa2', 'Marca', 'NInscripcion',
        'DNI_Conductor', 'Nombre_Conductor', 'NLicencia', 'Tipo_DocTransp',
        'DocIdentTransp', 'Nombre_Transp',
        'Afecto_IGV', 'pIGV', 'IGV', 'Valor_Venta', 'Inafecto',
        'Exonerada', 'Total_Pagar', 'Afecta_Kardex', 'TipoDestinatario_Id', 'Destinatario_Id', 'UndTransp_Id',
        'Conductor_Id', 'Transportista_Id', 'Traslado',
        'SedeDesitno_Id', 'AlmDestino_Id', 'Sucursal_Id', 'Almacen_Id',
        'Observacion', 'IdOrden', 'Estado'
    ];

    // Asignar valores a los parámetros con nombres exactos
    $stmt->bindValue(':p_empresa_id', $data['Empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_docfiscal_id', $data['DocFiscal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_operacion_id', $data['Operacion_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_motivoguia_id', $data['MotivoGuia_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie', $data['NSerie'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ndocumento', $data['NDocumento'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_emision', $data['Fecha_Emision'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_traslado', $data['Fecha_Traslado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_direccion_partida', $data['Direccion_Partida'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ubigeo_partida', $data['Ubigeo_Partida'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipodoc_cliente', $data['Tipo_DocIdentDest'], PDO::PARAM_INT);
    $stmt->bindValue(':p_ndoc_cliente', $data['DocIdentidad'], PDO::PARAM_STR);
    $stmt->bindValue(':p_razonsocial', $data['Razon_Social'], PDO::PARAM_STR);
    $stmt->bindValue(':p_direccion_llegada', $data['Direccion_Destino'], PDO::PARAM_STR);
    $stmt->bindValue(':p_ubigeo_llegada', $data['Ubigeo_Destino'], PDO::PARAM_STR);
    $stmt->bindValue(':p_placa', $data['Placa'], PDO::PARAM_STR);
    $stmt->bindValue(':p_placa2', $data['Placa2'], PDO::PARAM_STR);
    $stmt->bindValue(':p_marca', $data['Marca'], PDO::PARAM_STR);
    $stmt->bindValue(':p_nroinscripcion', $data['NInscripcion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_dniconductor', $data['DNI_Conductor'], PDO::PARAM_STR);
    $stmt->bindValue(':p_nombreconductor', $data['Nombre_Conductor'], PDO::PARAM_STR);
    $stmt->bindValue(':p_licencia', $data['NLicencia'], PDO::PARAM_STR);
    $stmt->bindValue(':p_tipodoc_transportista', $data['Tipo_DocTransp'], PDO::PARAM_INT);
    $stmt->bindValue(':p_ndoc_transportista', $data['DocIdentTransp'], PDO::PARAM_STR);
    $stmt->bindValue(':p_nombre_transportista', $data['Nombre_Transp'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto_igv', filter_var($data['Afecto_IGV'] ?? false, FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_pigv', $data['pIGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_igv', $data['IGV'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecto', $data['Valor_Venta'], PDO::PARAM_STR);
    $stmt->bindValue(':p_inafecto', $data['Inafecto'], PDO::PARAM_STR);
    $stmt->bindValue(':p_exonerado', $data['Exonerada'], PDO::PARAM_STR);
    $stmt->bindValue(':p_total', $data['Total_Pagar'], PDO::PARAM_STR);
    $stmt->bindValue(':p_afecta_kardex', filter_var($data['Afecta_Kardex'] ?? false, FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_tipodestinatario_id', $data['TipoDestinatario_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_cliente_id', $data['Destinatario_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_unidadtransp_id', $data['UndTransp_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_conductor_id', $data['Conductor_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_transportista_id', $data['Transportista_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_trasladado', filter_var($data['Traslado'] ?? false, FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':p_sededestino_id', $data['SedeDesitno_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_almdestino_id', $data['AlmDestino_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $data['Sucursal_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_almacen_id', $data['Almacen_Id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_observacion', $data['Observacion'], PDO::PARAM_STR);
    $stmt->bindValue(':p_idorden', $data['IdOrden'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado', $data['Estado'], PDO::PARAM_STR);
    $stmt->bindValue(':p_detalle', json_encode($data['detalle']), PDO::PARAM_STR);
    $stmt->bindValue(':p_series', json_encode($data['series']), PDO::PARAM_STR);

    // JSON de arrays detalle y series
    $stmt->bindValue(":p_detalle", json_encode($data['detalle']), PDO::PARAM_STR);
    $stmt->bindValue(":p_series", json_encode($data['series']), PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $id = $result['idordenalmacen'] ?? 0;

    $conn->commit();

    echo json_encode([
        "ESTADO" => $id > 0 ? "00" : "11",
        "ID" => $id,
        "MENSAJE" => $id > 0 ? "ORDEN PROCESADA CON ÉXITO" : "ERROR AL PROCESAR ORDEN"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    if ($conn && $conn->inTransaction()) {
        $conn->rollBack();
    }
    echo json_encode([
        "ESTADO" => "11",
        "ID" => 0,
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
?>
