<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
//include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
//$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    // file_put_contents("log_pagos.txt", print_r($data, true));

    if ($data === null) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    if (!isset($data['detalle']) || !is_array($data['detalle'])) {
        throw new Exception("El campo 'detalle' es obligatorio y debe ser un array.");
    }

    $conn->beginTransaction();

    $stmt = $conn->prepare("SELECT procesar_pago(
        :p_nrecibo, :p_fecha, :p_importe, :p_nombre, :p_moneda, :p_tipo_cambio,
        :p_banco, :p_ctacte, :p_lugar, :p_operacion,
        :p_proveedor_id, :p_caja_id, :p_nomcaja, :p_observacion,
        :p_afecta_cajasunat, :p_sucursal_id, :p_empresa_id,
        :p_idpago_mod, :p_estado, :p_detalle
    ) AS id_pago");

    $AfecSunat = filter_var($data['Afecta_CajaSunat'], FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);

    $stmt->bindValue(":p_nrecibo",        $data['NRecibo']);
    $stmt->bindValue(":p_fecha",          $data['Fecha']);
    $stmt->bindValue(":p_importe",        $data['Deuda']);
    $stmt->bindValue(":p_nombre",         $data['Nombre']);
    $stmt->bindValue(":p_moneda",         $data['Moneda']);
    $stmt->bindValue(":p_tipo_cambio",    $data['Tipo_Cambio']);
    $stmt->bindValue(":p_banco",          $data['Banco']);
    $stmt->bindValue(":p_ctacte",         $data['CtaBco']);
    $stmt->bindValue(":p_lugar",          $data['Lugar_Pago']);
    $stmt->bindValue(":p_operacion",      $data['NOperacion']);
    $stmt->bindValue(":p_proveedor_id",   $data['Proveedor_Id']);
    $stmt->bindValue(":p_caja_id",        $data['Caja_Id']);
    $stmt->bindValue(":p_nomcaja",        $data['NomCaja']);
    $stmt->bindValue(":p_observacion",    $data['Observacion'] ?? '');
    $stmt->bindValue(":p_afecta_cajasunat", $AfecSunat, PDO::PARAM_BOOL);
    $stmt->bindValue(":p_sucursal_id",    $data['Sucursal_Id']);
    $stmt->bindValue(":p_empresa_id",     $data['Empresa_Id']);
    $stmt->bindValue(":p_idpago_mod",     $data['nIdCob_Mod'] ?? 0);
    $stmt->bindValue(":p_estado",         $data['Estado']);
    $stmt->bindValue(":p_detalle",        json_encode($data['detalle'], JSON_UNESCAPED_UNICODE));

    $stmt->execute();

    $idPago = $stmt->fetchColumn();
    $conn->commit();

    echo json_encode([
        "ESTADO" => $idPago > 0 ? "1" : "0",
        "ID" => $idPago ?: 0,
        "MENSAJE" => $idPago > 0 ? "EL PAGO SE PROCESÓ CORRECTAMENTE" : "ERROR AL PROCESAR EL PAGO"
    ], JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ]);
} finally {
    $conn = null;
}
?>
