<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Esperamos: [empresa_id, sucursal_id, producto_id]
    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Datos incompletos (se espera [empresa_id, sucursal_id, producto_id])");
    }

    $empresa_id  = (int)$datos[0];
    $sucursal_id = (int)$datos[1];
    $producto_id = (int)$datos[2];

    // Ajusta el nombre exacto de tu tabla si fuera diferente
    $sql = "SELECT 
                pprecio_menor, pprecio_mayor, pprecio_dist,
                pminimo_menor, pminimo_mayor, pminimo_dist,
                precmenor_und, precmenor_fra,
                precmayor_und, precmayor_fra,
                precdist_und,  precdist_fra
            FROM precios_sucursal
            WHERE empresa_id = :empresa_id
              AND sucursal_id = :sucursal_id
              AND producto_id = :producto_id
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id',  $empresa_id,  PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode($row ? [$row] : [], JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    error_response("Error en base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}