<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $body = file_get_contents("php://input");
    $datos = json_decode($body, true);

    // Espera: [empresa_id, sucursal_id, doc("F001-00001234") ó [serie,numero], producto_id]
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros inválidos.");
    }

    $empresa_id  = (int)$datos[0];
    $sucursal_id = (int)$datos[1];

    // Permite enviar "F001-00001234" o bien ["F001","00001234"]
    $serie = ""; $numero = "";
    if (is_array($datos[2])) {
        $serie  = (string)$datos[2][0];
        $numero = (string)$datos[2][1];
    } else {
        $doc = trim((string)$datos[2]);
        $p = explode("-", $doc, 2);
        if (count($p) !== 2) throw new Exception("Documento inválido, use 'SERIE-NUMERO'.");
        $serie  = trim($p[0]);
        $numero = trim($p[1]);
    }

    $producto_id = isset($datos[3]) ? (int)$datos[3] : 0;

    $sql = "SELECT * FROM public.get_costo_compra_por_doc(:e,:s,:ser,:num,:pid)";
    $st  = $conn->prepare($sql);
    $st->bindValue(':e',   $empresa_id,  PDO::PARAM_INT);
    $st->bindValue(':s',   $sucursal_id, PDO::PARAM_INT);
    $st->bindValue(':ser', $serie,       PDO::PARAM_STR);
    $st->bindValue(':num', $numero,      PDO::PARAM_STR);
    $st->bindValue(':pid', $producto_id, PDO::PARAM_INT);
    $st->execute();

    $row = $st->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        "ok"   => true,
        "data" => $row ?: null
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["ok"=>false, "error"=>$e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    unset($st); $conn = null;
}
