<?php
include_once '../conexion.php';
//include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
//$usuarioId = TokenValidator::validar($conn);

$input = json_decode(file_get_contents("php://input"), true);
$producto_id = $input[0] ?? null;

if (!$producto_id) {
    http_response_code(400);
    echo json_encode(["error" => "Producto no especificado"]);
    exit;
}

$sql = "SELECT pp.id, pp.proveedor_ruc, pp.codigo_proveedor, pp.descripcion_proveedor, p.nombre AS proveedor_nombre, 
        pp.flete, pp.estiba, pp.descuento
        FROM productos_proveedor pp
        JOIN proveedores p ON p.documento_identidad = pp.proveedor_ruc
        WHERE pp.producto_id = :producto_id
        ORDER BY p.nombre";

try {
    $stmt = $conn->prepare($sql); // 73 corregido aqu
    $stmt->execute(['producto_id' => $producto_id]);
    $datos = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($datos, JSON_UNESCAPED_UNICODE);
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
}