<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: GET, POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    if (!$bodyRequest) {
        throw new Exception("No se recibió contenido en la petición.");
    }

    $datos = json_decode($bodyRequest, true);
    if (!is_array($datos) || count($datos) < 1) {
        throw new Exception("Se requiere al menos 1 parámetro: [empresa_id]");
    }

    $empresaId = $datos[0];

    $sql = "SELECT id, nombre, documento_identidad 
            FROM proveedores 
            WHERE empresa_id = :empresa_id
            ORDER BY nombre ASC";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $empresaId, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
