<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $conn->beginTransaction();

    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación de campos clave (esperamos un objeto asociativo)
    $camposEsperados = [
        'cDocIdent', 'DocIdentidad', 'RazonSocial', 'Direccion', 'Ubigeo',
        'Distrito', 'Provincia', 'Region', 'Contacto', 'Email',
        'CtaBancaria1', 'CtaBancaria2', 'Telefono1', 'Telefono2',
        'ID_EMPRESA', 'Id_Proveedor', 'Estado'
    ];

    foreach ($camposEsperados as $campo) {
        if (!isset($datos[$campo])) {
            throw new Exception("Falta el parámetro requerido: $campo");
        }
    }

    $sql = "SELECT im_proveedor(
        :ctipodoc, :cdocidentidad, :cnombre, :cdireccion, :cubigeo,
        :cdistrito, :cprovincia, :cregion, :ccontacto, :cemail,
        :ccuentabco1, :ccuentabco2, :cfono1, :cfono2, :cempresa_id,
        :nidprov, :cestado
    ) AS proveedor_id";

    $stmt = $conn->prepare($sql);

    // Enlazar parámetros usando claves nombradas
    $stmt->bindValue(':ctipodoc',     $datos['cDocIdent'],      PDO::PARAM_INT);
    $stmt->bindValue(':cdocidentidad',$datos['DocIdentidad'],   PDO::PARAM_STR);
    $stmt->bindValue(':cnombre',      $datos['RazonSocial'],    PDO::PARAM_STR);
    $stmt->bindValue(':cdireccion',   $datos['Direccion'],      PDO::PARAM_STR);
    $stmt->bindValue(':cubigeo',      $datos['Ubigeo'],         PDO::PARAM_STR);
    $stmt->bindValue(':cdistrito',    $datos['Distrito'],       PDO::PARAM_STR);
    $stmt->bindValue(':cprovincia',   $datos['Provincia'],      PDO::PARAM_STR);
    $stmt->bindValue(':cregion',      $datos['Region'],         PDO::PARAM_STR);
    $stmt->bindValue(':ccontacto',    $datos['Contacto'],       PDO::PARAM_STR);
    $stmt->bindValue(':cemail',       $datos['Email'],          PDO::PARAM_STR);
    $stmt->bindValue(':ccuentabco1',  $datos['CtaBancaria1'],   PDO::PARAM_STR);
    $stmt->bindValue(':ccuentabco2',  $datos['CtaBancaria2'],   PDO::PARAM_STR);
    $stmt->bindValue(':cfono1',       $datos['Telefono1'],      PDO::PARAM_STR);
    $stmt->bindValue(':cfono2',       $datos['Telefono2'],      PDO::PARAM_STR);
    $stmt->bindValue(':cempresa_id',  $datos['ID_EMPRESA'],     PDO::PARAM_INT);
    $stmt->bindValue(':nidprov',      $datos['Id_Proveedor'],   PDO::PARAM_INT);
    $stmt->bindValue(':cestado',      $datos['Estado'],         PDO::PARAM_STR);

    // Ejecutar
    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $proveedor_id = $resultado['proveedor_id'] ?? 0;

    if ($proveedor_id > 0) {
        $conn->commit();
        echo json_encode([
            "ESTADO" => "1",
            "ID" => $proveedor_id,
            "MENSAJE" => "Proveedor procesado correctamente"
        ], JSON_UNESCAPED_UNICODE);
    } else {
        $conn->rollBack();
        echo json_encode([
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "No se pudo registrar o actualizar el proveedor"
        ], JSON_UNESCAPED_UNICODE);
    }

} catch (Exception $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
