<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $conn->beginTransaction();

    $bodyRequest = file_get_contents("php://input");
    if (!$bodyRequest) {
        throw new Exception("Body vacío");
    }
    $datos = json_decode($bodyRequest, true);
    if (!is_array($datos)) {
        throw new Exception("JSON inválido");
    }

    // Validaciones mínimas (ajusta a tu gusto)
    foreach (['cDocIdent','DocIdentidad','RazonSocial','ID_EMPRESA','Estado'] as $req) {
        if (!array_key_exists($req, $datos)) {
            throw new Exception("Falta el parámetro requerido: $req");
        }
    }

    // Opcional: si no te envían sucursal, pon un default
    if (!isset($datos['SucursalId'])) {
        $datos['SucursalId'] = 1; // <-- AJUSTA si corresponde
    }

    // Llamada 100% JSON (la función devuelve JSON)
    $sql  = "SELECT public.procesar_proveedor(:json)::json AS r";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':json', json_encode($datos, JSON_UNESCAPED_UNICODE));
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$row || empty($row['r'])) {
        throw new Exception("Sin respuesta del motor");
    }

    $resp = json_decode($row['r'], true);
    if (!is_array($resp)) {
        throw new Exception("Respuesta del motor indebida");
    }

    if (isset($resp['ESTADO']) && $resp['ESTADO'] === '1') {
        $conn->commit();
    } else {
        $conn->rollBack();
    }

    echo json_encode($resp, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    if ($conn && $conn->inTransaction()) $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        "ESTADO"  => "0",
        "ID"      => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
