<?php
error_reporting(E_ALL ^ E_NOTICE);

include_once '../conexion.php';

// Permitir la conexin desde cualquier origen
header("Access-Control-Allow-Origin: *");
// Permitir la ejecucin de los mtodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

// Obtener los datos combinados del cuerpo de la solicitud
$datos = json_decode(file_get_contents("php://input"), true);

// Verificar si la decodificacin JSON fue exitosa
if (json_last_error() !== JSON_ERROR_NONE) {
    print_json(['error' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

// Validar los datos recibidos
if (!isset($datos[0]) || !isset($datos[1])) {
    print_json(['error' => 'Missing required parameters.']);
    exit;
}

// Preparar la consulta
$sql = "CALL Actualiza_TempSeriesProd(?, ?)";

if ($stmt = mysqli_prepare($conn, $sql)) {
    // Vincular los parmetros
    mysqli_stmt_bind_param($stmt, 'is', $datos[0], $datos[1]);

    // Ejecutar la consulta
    mysqli_stmt_execute($stmt);

    // Obtener el resultado
    $result = mysqli_stmt_get_result($stmt);

    $rows = array();

    if ($result) {
        if (mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $rows[] = $row;
            }
            mysqli_free_result($result);
        } else {
            print_json([]);
            exit;
        }
    } else {
        print_json(['error' => 'Query execution failed: ' . mysqli_error($conn)]);
        exit;
    }

    // Cerrar la declaracin
    mysqli_stmt_close($stmt);
} else {
    print_json(['error' => 'Failed to prepare the SQL statement: ' . mysqli_error($conn)]);
    exit;
}

// Cerrar la conexin a la base de datos
mysqli_close($conn);

print_json($rows);

function print_json($data) {
    header("Content-Type: application/json; charset=utf-8");
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    
    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            echo ' - Maximum stack depth exceeded';
            break;
        case JSON_ERROR_STATE_MISMATCH:
            echo ' - Underflow or the modes mismatch';
            break;
        case JSON_ERROR_CTRL_CHAR:
            echo ' - Unexpected control character found';
            break;
        case JSON_ERROR_SYNTAX:
            echo ' - Syntax error, malformed JSON';
            break;
        case JSON_ERROR_UTF8:
            echo ' - Malformed UTF-8 characters, possibly incorrectly encoded';
            break;
        default:
            echo ' - Unknown error';
            break;
    }
}
?>
