<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (!isset($datos['cIdProducto']) || !isset($datos['cSerie'])) {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'Datos incompletos'));
    exit;
}

$cIdProducto = $datos['cIdProducto'];
$cSerie = $datos['cSerie'];

// Preparar la llamada al procedimiento almacenado
$sql = $conn->prepare("CALL Eliminar_SeriesProd(?, ?, @result)");
$sql->bind_param("is", $cIdProducto, $cSerie);
$sql->execute();
$sql->close();

// Obtener el valor del parámetro de salida
$result = $conn->query("SELECT @result AS resultado")->fetch_assoc();

if ($result['resultado'] > 0) {
    print_json(array('ESTADO' => '1', 'MENSAJE' => 'Registro eliminado con éxito', 'rowsAffected' => $result['resultado']));
} else {
    print_json(array('ESTADO' => '0', 'MENSAJE' => 'No se eliminó el registro seleccionado', 'rowsAffected' => $result['resultado']));
}

mysqli_close($conn);

function print_json($data) {
    header("HTTP/1.1");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>
