<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    print_json(['ESTADO' => '0', 'MENSAJE' => 'Malformed JSON: ' . json_last_error_msg()]);
    exit;
}

if (count($datos) !== 13) {
    print_json(['ESTADO' => '0', 'MENSAJE' => 'Número incorrecto de parámetros']);
    exit;
}

$sql = $conn->prepare("CALL Salida_SeriesProd(?,?,?,?,?,?,?,?,?,?,?,?,?)");
$sql->bind_param("isiisssiiisss", $datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7], $datos[8], $datos[9], $datos[10], $datos[11], $datos[12]);

$sql->execute();

$rowsAffected = $sql->affected_rows;

if ($rowsAffected > 0) {
    print_json(['ESTADO' => '1', 'MENSAJE' => 'Registro guardado/actualizado con éxito']);
} else {
    print_json(['ESTADO' => '0', 'MENSAJE' => 'No se realizaron cambios en la base de datos']);
}

$sql->close();
$conn->close();

function print_json($data) {
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($data, JSON_PRETTY_PRINT);
}
?>


