
<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar que el parámetro sea un número entero
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("El ID proporcionado no es válido.");
    }

    $idSeriexDoc = (int) $datos[0];

    // Consulta con procedimiento almacenado en PostgreSQL
    $sql = "SELECT * FROM Consultar_SeriexSucursal_Id(:idSeriexDoc)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":idSeriexDoc", $idSeriexDoc, PDO::PARAM_INT);
    
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$rows) {
        error_log("⚠️ No se encontraron registros para ID: $idSeriexDoc.");
        $rows = [];
    }

    print_json($rows);
} catch (Exception $e) {
    error_log("❌ Error en la API: " . $e->getMessage());
    error_response($e->getMessage());
} finally {
    $stmt = null;
    $conn = null;
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Maximum stack depth exceeded');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Underflow or the modes mismatch');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Unexpected control character found');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Syntax error, malformed JSON');
            break;
        case JSON_ERROR_UTF8:
            error_response('Malformed UTF-8 characters, possibly incorrectly encoded');
            break;
        default:
            error_response('Unknown error');
            break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>