<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 9) {
        throw new Exception("Parámetros incompletos. Se requieren 9 datos.");
    }

    // Llamada a la función en PostgreSQL (puedes renombrar si la migras como PROCEDURE)
    $sql = "SELECT * FROM im_seriexsucursal(:p_docfiscal_id, :p_nserie, :p_numero, :p_impresiones, :p_usuario_id, :p_sucursal_id, :p_empresa_id, :p_id_sxs, :p_estado)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':p_docfiscal_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':p_nserie', $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':p_numero', $datos[2], PDO::PARAM_STR);
    $stmt->bindValue(':p_impresiones', $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':p_usuario_id', $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $datos[5], PDO::PARAM_INT);
    $stmt->bindValue(':p_empresa_id', $datos[6], PDO::PARAM_INT);
    $stmt->bindValue(':p_id_sxs', $datos[7], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado', $datos[8], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[8] === "NUEVO") {
        if ($result && isset($result['idseriexdoc']) && $result['idseriexdoc'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['idseriexdoc'],
                "MENSAJE" => "LA INFORMACION SE GUARDO CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACION"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => "0",
            "MENSAJE" => "LA INFORMACION SE ACTUALIZO CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["ESTADO" => "0", "ID" => "0", "MENSAJE" => "ERROR: " . $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
