<?php
include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$usuario_id = $datos[0] ?? 0;
$token = $datos[1] ?? '';

try {
    $stmt = $conn->prepare("INSERT INTO tokens_sesion (usuario_id, token) VALUES (:usuario_id, :token)
                            ON CONFLICT (usuario_id) DO UPDATE SET token = EXCLUDED.token, fecha_creacion = CURRENT_TIMESTAMP");
    $stmt->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmt->bindParam(':token', $token, PDO::PARAM_STR);
    $stmt->execute();

    echo json_encode(["ESTADO" => "1", "ID" => $usuario_id, "MENSAJE" => "Token guardado"]);
} catch (Exception $e) {
    echo json_encode(["ESTADO" => "0", "ID" => 0, "MENSAJE" => "Error: " . $e->getMessage()]);
}
?>
