<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Ruta al archivo autoload.php generado por Composer
require_once __DIR__ . '/vendor/autoload.php';

include_once '../conexion.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Reader\Xlsx;

// Verificar conexion
if ($conn->connect_error) {
    die("Conexion fallida: " . $conn->connect_error);
}

// Ruta al archivo Excel
$excelFilePath = __DIR__ . '/archivo.xlsx';
if (!file_exists($excelFilePath)) {
    die("El archivo Excel no existe en la ruta especificada: " . $excelFilePath);
}

$reader = new Xlsx();
$spreadsheet = $reader->load($excelFilePath);

// Array de hojas y sus tablas correspondientes
$sheetTableMapping = [
    'chacha' => 'stock_chacha',
    'parada' => 'stock_parada',
    'avenida' => 'stock_avenida',
    'plaza' => 'stock_plaza'
];

// Iterar sobre todas las hojas
foreach ($spreadsheet->getSheetNames() as $sheetIndex => $sheetName) {
    if (!isset($sheetTableMapping[$sheetName])) {
        echo "No hay tabla definida para la hoja: $sheetName<br>";
        continue;
    }

    $sheet = $spreadsheet->getSheet($sheetIndex);
    $tableName = $sheetTableMapping[$sheetName];

    // Iterar sobre todas las filas de la hoja
    foreach ($sheet->getRowIterator() as $row) {
        $cellIterator = $row->getCellIterator();
        $cellIterator->setIterateOnlyExistingCells(false);

        $values = [];
        foreach ($cellIterator as $cell) {
            if ($cell->getColumn() > 'C') {
                continue; // Solo procesamos columnas A, B y C
            }
            
            if ($cell->getValue() === null) {
                $values[] = 'NULL';
            } else {
                $cellValue = $cell->getValue();
                if (is_numeric($cellValue)) {
                    $values[] = $cellValue;
                } else {
                    $values[] = "'" . $conn->real_escape_string($cellValue) . "'";
                }
            }
        }

        // Asegurarse de que haya exactamente 3 valores (para columnas A, B, C)
        while (count($values) < 3) {
            $values[] = 'NULL';
        }

        // Construir consulta SQL especificando las columnas A, B, C
        $query = "INSERT INTO $tableName (producto, serie, costo) VALUES (" . implode(',', $values) . ")";
        
        // Ejecutar la consulta
        if ($conn->query($query) === TRUE) {
            echo "Datos insertados correctamente en la tabla $tableName.<br>";
        } else {
            echo "Error al insertar datos en la tabla $tableName: " . $conn->error . "<br>";
        }
    }
}

// Cerrar conexion
$conn->close();
?>
