<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = array();

try {
    // Verificar que $datos[0] está definido
    if (!isset($datos[0])) {
        error_response("Falta el parámetro requerido");
    }

    $nombre = $datos[0]; // Nombre del almacén a buscar

    // Consulta SQL con parámetros preparados
    $sql = "SELECT * FROM almacenes WHERE nombre = :nombre AND principal = 1 AND activo = 1 ORDER BY principal DESC";
    
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->execute();

    // Obtener los resultados
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
}

// Cerrar la conexión (opcional)
$conn = null;

// Imprimir JSON
print_json($rows);

// Función para imprimir JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error en la conversión a JSON: " . json_last_error_msg());
    }
}

// Función para manejar errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
