<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';

try {
    // Obtener JSON del body
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos['empresa_id'], $datos['sucursal_id'], $datos['clave'])) {
        throw new Exception("Parámetros 'empresa_id', 'sucursal_id' y 'clave' son requeridos.");
    }

    $empresa_id = (int) $datos['empresa_id'];
    $sucursal_id = (int) $datos['sucursal_id'];
    $clave = trim($datos['clave']);

    $sql = "SELECT valor FROM configuracion_sistema 
            WHERE empresa_id = :empresa_id 
              AND sucursal_id = :sucursal_id 
              AND clave = :clave 
            LIMIT 1";

    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindValue(':clave', $clave, PDO::PARAM_STR);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$row) {
        error_log("⚠️ Parámetro no encontrado: $clave (empresa $empresa_id, sucursal $sucursal_id)");
        error_response("Parámetro no encontrado.");
    }

    print_json($row);

} catch (Exception $e) {
    error_log("❌ Error en leer_parametro: " . $e->getMessage());
    error_response("Error: " . $e->getMessage());
} finally {
    unset($stmt);
    $conn = null;
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}

function error_response($message) {
    http_response_code(400);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}