<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permite la ejecución de los métodos
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a la base de datos PostgreSQL con PDO
include_once '../conexion.php';

// Obtener el cuerpo de la solicitud y decodificarlo
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$rows = array();

try {
    // Parámetro del procedimiento almacenado
    $param1 = $datos[0]; // Primer parámetro (integer)

    // Llamada al procedimiento almacenado
    $sql = "SELECT * FROM Activa_SubMenu(:param1)";

    // Preparar la sentencia
    $stmt = $conn->prepare($sql);

    // Vincular parámetros
    $stmt->bindParam(':param1', $param1, PDO::PARAM_INT);

    // Ejecutar la sentencia
    $stmt->execute();

    // Obtener los resultados
    if ($stmt->rowCount() > 0) {
        while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
            $rows[] = $row;
        }
    } else {
        // Si no se encuentran registros, devolver un array vacío
        $rows = [];
    }
} catch (PDOException $e) {
    error_response("ERROR en la consulta: " . $e->getMessage());
}

// Cerrar la conexión a la base de datos (opcional, ya que PDO la cierra automáticamente al final del script)
$conn = null;

// Imprimir la respuesta en formato JSON
print_json($rows);

// Función para imprimir JSON y manejar errores de codificación
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE:
            break;
        case JSON_ERROR_DEPTH:
            error_response('Máxima profundidad de pila excedida');
            break;
        case JSON_ERROR_STATE_MISMATCH:
            error_response('Desbordamiento o desajuste de modos');
            break;
        case JSON_ERROR_CTRL_CHAR:
            error_response('Caracter de control inesperado encontrado');
            break;
        case JSON_ERROR_SYNTAX:
            error_response('Error de sintaxis, JSON mal formado');
            break;
        case JSON_ERROR_UTF8:
            error_response('Caracteres UTF-8 mal formados, posiblemente codificados incorrectamente');
            break;
        default:
            error_response('Error desconocido');
            break;
    }
}

// Función para responder con error en JSON
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>