<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (!isset($datos[0]) || !is_numeric($datos[0])) {
    error_response("Parámetro usuario_id inválido.");
}

$usuario_id = (int) $datos[0];
$rows = [];

try {
    // Menús
    $sqlMenu = "SELECT opcion, nombre, activo FROM menu WHERE usuario_id = :usuario_id ORDER BY opcion";
    $stmtMenu = $conn->prepare($sqlMenu);
    $stmtMenu->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
    $stmtMenu->execute();
    $menus = $stmtMenu->fetchAll(PDO::FETCH_ASSOC);

    foreach ($menus as &$menu) {
        $menu['submenus'] = [];

        // Submenús
        $sqlSubmenu = "SELECT opcion, nombre, activo FROM submenu 
                       WHERE menu = :menu AND usuario_id = :usuario_id ORDER BY opcion";
        $stmtSubmenu = $conn->prepare($sqlSubmenu);
        $stmtSubmenu->bindParam(':menu', $menu['opcion'], PDO::PARAM_INT);
        $stmtSubmenu->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
        $stmtSubmenu->execute();
        $submenus = $stmtSubmenu->fetchAll(PDO::FETCH_ASSOC);

        foreach ($submenus as &$submenu) {
            $submenu['dialogos'] = [];

            // Diálogos con DISTINCT
            $sqlDialogo = "SELECT DISTINCT nombre, activo FROM dialogo 
                        WHERE submenu_id = :submenu_id AND usuario_id = :usuario_id 
                        ORDER BY nombre";
            $stmtDialogo = $conn->prepare($sqlDialogo);
            $stmtDialogo->bindParam(':submenu_id', $submenu['opcion'], PDO::PARAM_INT);
            $stmtDialogo->bindParam(':usuario_id', $usuario_id, PDO::PARAM_INT);
            $stmtDialogo->execute();
            $dialogos = $stmtDialogo->fetchAll(PDO::FETCH_ASSOC);

            // Filtro adicional para eliminar duplicados por nombre
            $unicos = [];
            $dialogoFinal = [];
            foreach ($dialogos as $d) {
                if (!in_array($d['nombre'], $unicos)) {
                    $unicos[] = $d['nombre'];
                    $dialogoFinal[] = $d;
                }
            }
            $submenu['dialogos'] = $dialogoFinal;
        }

        $menu['submenus'] = $submenus;
    }

    print_json($menus);
} catch (PDOException $e) {
    error_response("Error en la consulta: " . $e->getMessage());
}

$conn = null;

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: error_response('Maximum stack depth exceeded'); break;
        case JSON_ERROR_STATE_MISMATCH: error_response('Underflow or the modes mismatch'); break;
        case JSON_ERROR_CTRL_CHAR: error_response('Unexpected control character found'); break;
        case JSON_ERROR_SYNTAX: error_response('Syntax error, malformed JSON'); break;
        case JSON_ERROR_UTF8: error_response('Malformed UTF-8 characters, possibly incorrectly encoded'); break;
        default: error_response('Unknown error'); break;
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
