<?php
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';

$body = file_get_contents("php://input");
$data = json_decode($body, true);

$empresa_id = (int)($data[0] ?? 0);
$sucursal_id = (int)($data[1] ?? 0);

try {
    $sql = "SELECT * FROM ver_campana_activa(:empresa, :sucursal)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal', $sucursal_id, PDO::PARAM_INT);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row) {
        // ✅ Convertir 'productos' de string JSON a array asociativo
        if (isset($row['productos']) && is_string($row['productos'])) {
            $productos = json_decode($row['productos'], true);
            $row['productos'] = $productos ?: []; // si hay error en decode, dejar como []
        }
        echo json_encode($row);
    } else {
        echo json_encode([]);
    }
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => $e->getMessage()]);
}
