<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8"); 

// Incluir la conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar si se recibió un parámetro válido
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("Parámetro inválido.");
    }

    $sucursal_id = (int) $datos[0];

    // Preparar la consulta con una llamada a función en PostgreSQL
    $sql = "SELECT * FROM Consultar_Sucursal_Id(:sucursal_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    
    // Ejecutar la consulta
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Enviar la respuesta en formato JSON
    print_json($rows ?: []); // Si no hay registros, devolver un array vacío

} catch (Exception $e) {
    error_response($e->getMessage());
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
