<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8"); 

// Incluir la conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token de sesión
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("Parámetro de campaña inválido.");
    }

    $campana_id = (int) $datos[0];

    $sql = "SELECT * FROM consultar_campana_puntos_por_id(:campana_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':campana_id', $campana_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows ?: []);

} catch (Exception $e) {
    error_response($e->getMessage());
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
