<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir el archivo de conexión
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Obtener el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // file_put_contents('debug_post.log', $bodyRequest);

    // Validar que los datos sean correctos
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("Parámetro inválido");
    }

    // Preparar la consulta en PostgreSQL
    $sql = "SELECT * FROM listar_detcampana_puntos(:param)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":param", $datos[0], PDO::PARAM_INT);
    
    // Ejecutar la consulta
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Imprimir la respuesta en formato JSON
    print_json($rows);
} catch (Exception $e) {
    error_response($e->getMessage());
}

// Función para imprimir JSON con validación de errores
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al codificar JSON: " . json_last_error_msg());
    }
}

// Función para manejar errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
