<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

// Incluir la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    // Configurar errores en PDO
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Validar parámetros
    if (!isset($datos[0]) || !is_numeric($datos[0]) || !isset($datos[1]) || !is_string($datos[1])) {
        throw new Exception("Parámetros inválidos");
    }

    // Preparar y ejecutar el procedimiento almacenado
    $sql = "SELECT * FROM Listar_Sucursales(?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(1, $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(2, $datos[1], PDO::PARAM_STR);
    $stmt->execute();
    
    // Obtener los resultados
    $response = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt->closeCursor(); // Liberar resultados

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Cerrar la conexión
$conn = null;

// Devolver la respuesta en JSON
print_json($response);

// Función para imprimir JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

// Función para manejar errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
