<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Incluir el archivo de conexión
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token del usuario
$usuarioId = TokenValidator::validar($conn);

try {
    // Obtener y decodificar los datos enviados
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar parámetros
    if (!isset($datos[0]) || !is_numeric($datos[0])) {
        throw new Exception("ID de empresa inválido.");
    }

    $empresa_id = (int) $datos[0];
    $filtro = isset($datos[1]) ? $datos[1] : '';

    // Llamada a la función PostgreSQL con 2 parámetros
    $sql = "SELECT * FROM listar_campanas_puntos(:empresa_id, :filtro)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(":empresa_id", $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(":filtro", $filtro, PDO::PARAM_STR);

    // Ejecutar y obtener resultados
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows);

} catch (Exception $e) {
    error_response($e->getMessage());
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al codificar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
