<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Error en el JSON recibido: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        http_response_code(400);
        exit();
    }

    if (!isset($data['Estado']) || !isset($data['almacenes'])) {
        throw new Exception("Falta el campo 'Estado' o 'almacenes'.");
    }

    $conn->beginTransaction();  // 🔹 Iniciar transacción

    $sql = "SELECT im_sucursal(:ruc, :cod_sunat, :nombre, :direccion, :ubigeo, :distrito, :provincia, :region, 
                            :email, :fono1, :fono2, :cta_bancaria1, :cta_bancaria2, :afecto_cmp, :pigv_cmp, 
                            :afecto_vta, :pigv_vta, :etiquetera, :almacen_id, :empresa_id, :ip_contometro, 
                            :usuario_contometro, :clave_contometro, :facturacion_automatica, :telemetria_automatica, 
                            :envio_automatico_post_venta, :boletas_cierre_turno, :boletas_doc_anterior, :canje_afecta_kardex,
                            :filtro_canje_por_cliente, :descuento_cliente, :adelanto_cliente, :campana_puntos,
                            :importar_xml_ventas, :importar_xml_compras, :id_sucursal, :estado, :almacenes) AS idsucursal";

    $stmt = $conn->prepare($sql);

    // Parámetros existentes...
    $stmt->bindValue(':ruc', $data['Ruc'], PDO::PARAM_STR);
    $stmt->bindValue(':cod_sunat', $data['CodSunat'], PDO::PARAM_STR);
    $stmt->bindValue(':nombre', $data['Nombre'], PDO::PARAM_STR);
    $stmt->bindValue(':direccion', $data['Direccion'], PDO::PARAM_STR);
    $stmt->bindValue(':ubigeo', $data['Ubigeo'], PDO::PARAM_STR);
    $stmt->bindValue(':distrito', $data['Distrito'], PDO::PARAM_STR);
    $stmt->bindValue(':provincia', $data['Provincia'], PDO::PARAM_STR);
    $stmt->bindValue(':region', $data['Region'], PDO::PARAM_STR);
    $stmt->bindValue(':email', $data['Email'], PDO::PARAM_STR);
    $stmt->bindValue(':fono1', $data['Fono1'], PDO::PARAM_STR);
    $stmt->bindValue(':fono2', $data['Fono2'], PDO::PARAM_STR);
    $stmt->bindValue(':cta_bancaria1', $data['CtaBancaria1'], PDO::PARAM_STR);
    $stmt->bindValue(':cta_bancaria2', $data['CtaBancaria2'], PDO::PARAM_STR);
    $stmt->bindValue(':afecto_cmp', $data['AfectoCmp'], PDO::PARAM_BOOL);
    $stmt->bindValue(':pigv_cmp', $data['PIGV_Cmp'], PDO::PARAM_STR);
    $stmt->bindValue(':afecto_vta', $data['AfectoVta'], PDO::PARAM_BOOL);
    $stmt->bindValue(':pigv_vta', $data['PIGV_Vta'], PDO::PARAM_STR);
    $stmt->bindValue(':etiquetera', $data['Etiquetera'], PDO::PARAM_BOOL);
    $stmt->bindValue(':almacen_id', $data['IdAlmacen'], PDO::PARAM_INT);
    $stmt->bindValue(':empresa_id', $data['IdEmpresa'], PDO::PARAM_INT);
    $stmt->bindValue(':ip_contometro', $data['IP_Contometro'], PDO::PARAM_STR);
    $stmt->bindValue(':usuario_contometro', $data['Usuario_Contometro'], PDO::PARAM_STR);
    $stmt->bindValue(':clave_contometro', $data['Clave_Contometro'], PDO::PARAM_STR);
    $stmt->bindValue(':facturacion_automatica', $data['Facturacion_Automatica'], PDO::PARAM_BOOL);
    $stmt->bindValue(':telemetria_automatica', $data['Telemetria_Automatica'], PDO::PARAM_BOOL);
    $stmt->bindValue(':envio_automatico_post_venta', $data['Envio_Automatico_Post_Venta'], PDO::PARAM_BOOL);
    $stmt->bindValue(':boletas_cierre_turno', $data['Boletas_Cierre_Turno'], PDO::PARAM_BOOL);
    $stmt->bindValue(':boletas_doc_anterior', $data['Boletas_Doc_Anterior'], PDO::PARAM_BOOL);
    $stmt->bindValue(':canje_afecta_kardex', $data['Canje_Afecta_Kardex'], PDO::PARAM_BOOL);
    $stmt->bindValue(':filtro_canje_por_cliente', $data['Filtro_Canje_Por_Cliente'], PDO::PARAM_BOOL);
    $stmt->bindValue(':descuento_cliente', $data['Descuento_Cliente'], PDO::PARAM_BOOL);
    $stmt->bindValue(':adelanto_cliente', $data['Adelanto_Cliente'], PDO::PARAM_BOOL);
    $stmt->bindValue(':campana_puntos', $data['Campana_Puntos'], PDO::PARAM_BOOL);
    $stmt->bindValue(':importar_xml_ventas', $data['Importar_XML_Ventas'], PDO::PARAM_BOOL);
    $stmt->bindValue(':importar_xml_compras', $data['Importar_XML_Compras'], PDO::PARAM_BOOL);
    $stmt->bindValue(':id_sucursal', $data['nIdSucursal'], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $data['Estado'], PDO::PARAM_STR);
    $stmt->bindValue(':almacenes', json_encode($data['almacenes']), PDO::PARAM_STR);

    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $idsucursal = (int) $resultado['idsucursal']; 

    // Respuesta según resultado
    if ($idsucursal > 0) {
        $conn->commit();
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $idsucursal,
            "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
        ];
    } else {
        $conn->rollBack();
        $respuesta = [
            "ESTADO" => "0",
            "ID" => 0,
            "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
        ];
    }

    // Respuesta final
    header("HTTP/1.1 200 OK");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();
    $respuesta = [
        "ESTADO" => "0",
        "ID" => 0,
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
    header("HTTP/1.1 500 Internal Server Error");
    header("Content-Type: application/json; charset=UTF-8");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);

} finally {
    $conn = null;
}