<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token de acceso
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode([
            'status' => 'error',
            'message' => 'Error en el JSON recibido: ' . json_last_error_msg()
        ], JSON_UNESCAPED_UNICODE);
        http_response_code(400);
        exit();
    }

    if (!isset($data['estado']) || !isset($data['detalle'])) {
        throw new Exception("Falta el campo obligatorio 'estado' o 'detalle'.");
    }

    $conn->beginTransaction();

    $sql = "SELECT im_campana_puntos(:fecha_inicio, :campana_id, :activo, :empresa_id, :sucursal_id, :estado, :detalle) AS idcampana";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':fecha_inicio', $data['fecha_inicio'], PDO::PARAM_STR);
    $stmt->bindValue(':campana_id', $data['campana_id'], PDO::PARAM_INT);
    $stmt->bindValue(':activo', $data['activo'], PDO::PARAM_BOOL);
    $stmt->bindValue(':empresa_id', $data['empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $data['sucursal_id'], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $data['estado'], PDO::PARAM_STR);
    $stmt->bindValue(':detalle', json_encode($data['detalle']), PDO::PARAM_STR);

    $stmt->execute();
    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $idcampana = (int) $resultado['idcampana'];

    if ($idcampana > 0) {
        $conn->commit();
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $idcampana,
            "MENSAJE" => "Campaña registrada correctamente."
        ];
    } else {
        $conn->rollBack();
        $respuesta = [
            "ESTADO" => "0",
            "ID" => 0,
            "MENSAJE" => "Error al registrar la campaña."
        ];
    }

    http_response_code(200);
    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    $conn->rollBack();
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => 0,
        "MENSAJE" => "ERROR SQL: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => 0,
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);

} finally {
    $conn = null;
}
