<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token del usuario
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer y decodificar el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar parámetros obligatorios
    if (!isset($datos['codigo_sunat']) || !isset($datos['empresa_id'])) {
        throw new Exception("Parámetros 'codigo_sunat' y 'empresa_id' son obligatorios.");
    }

    $codigo_sunat = strtoupper(trim($datos['codigo_sunat']));
    $empresa_id = intval($datos['empresa_id']);

    // Consultar si ya existe ese código SUNAT para la empresa
    $sql = "SELECT 1 
            FROM sucursales 
            WHERE UPPER(codigo_sunat) = :codigo_sunat 
              AND empresa_id = :empresa_id 
            LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':codigo_sunat', $codigo_sunat, PDO::PARAM_STR);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->execute();

    $existe = $stmt->fetchColumn() !== false;

    // Devolver resultado claro
    echo json_encode([
        'existe' => $existe,
        'codigo_sunat' => $codigo_sunat,
        'empresa_id' => $empresa_id
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Función para errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
