<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token del usuario
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer y decodificar el cuerpo de la solicitud
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación básica
    if (!isset($datos['nombre']) || !isset($datos['empresa_id'])) {
        throw new Exception("Parámetros 'nombre' y 'empresa_id' son obligatorios.");
    }

    $nombre = trim($datos['nombre']);
    $empresa_id = intval($datos['empresa_id']);

    // Consulta para verificar si existe la sucursal en la misma empresa
    $sql = "SELECT 1 FROM sucursales WHERE LOWER(nombre) = LOWER(:nombre) AND empresa_id = :empresa_id LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $nombre, PDO::PARAM_STR);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->execute();

    $existe = $stmt->fetchColumn() !== false;

    // Respuesta clara
    echo json_encode([
        'existe' => $existe,
        'nombre' => $nombre,
        'empresa_id' => $empresa_id
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    error_response($e->getMessage());
}

// Función de error
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
