<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Validar parámetros
    if (!isset($datos[0]) || !is_numeric($datos[0]) ||
        !isset($datos[1]) || !is_bool($datos[1]) &&
        !in_array($datos[1], [0, 1, "0", "1"], true) ||
        !isset($datos[2]) || !is_numeric($datos[2])) {
        throw new Exception("Parámetros inválidos");
    }

    // Preparar y ejecutar la función
    $sql = "SELECT anular_tanque(:id, :estado, :empresa) AS id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':id',      $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':estado',  filter_var($datos[1], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':empresa', $datos[2], PDO::PARAM_INT);
    $stmt->execute();

    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $id = $result['id'] ?? 0;

    if ($id > 0) {
        $response['ESTADO'] = "1";
        $response['ID'] = $id;
        $response['MENSAJE'] = filter_var($datos[1], FILTER_VALIDATE_BOOLEAN)
            ? "SE ACTIVÓ CORRECTAMENTE"
            : "SE DESACTIVÓ CORRECTAMENTE";
    } else {
        throw new Exception("No se encontró el tanque o no se pudo actualizar.");
    }

} catch (Exception $e) {
    error_response($e->getMessage());
}

$conn = null;
print_json($response);

// Utilidades
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['ESTADO' => '0', 'ID' => 0, 'MENSAJE' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
