<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros inválidos.");
    }

    $empresaId = (int) $datos[0];
    $sucursalId = (int) $datos[1];
    $tipoInforme = (int) $datos[2];

    // Consulta dinámica
    switch ($tipoInforme) {
        case 0: // CLIENTES
            $titulo = 'REPORTE DE CLIENTES';
            $sql = "SELECT 
                id, 
                nombre, 
                direccion, 
                telefono1
            FROM clientes
            WHERE empresa_id = $empresaId AND sucursal_id = $sucursalId
            ORDER BY nombre ASC";
            break;
        case 1: // SOLO CLIENTES CON LÍNEA DE CRÉDITO
            $titulo = 'REPORTE DE CLIENTES CON LINEA DE CREDITO';
            $sql = "SELECT id, nombre, importe_maximo, importe_consumido
                    FROM clientes
                    WHERE empresa_id = $empresaId AND sucursal_id = $sucursalId AND linea_credito = true
                    ORDER BY nombre ASC";
            break;
        case 2: // DESCUENTOS POR PRODUCTO
            $titulo = 'REPORTE DE CLIENTES CON DESCUENTOS POR PRODUCTO';
            $sql = "SELECT 
                    C.id, 
                    C.nombre, 
                    DC.importe AS descuento, 
                    P.nombre AS producto, 
                    DC.cantidad,
                    CASE 
                        WHEN DC.tipo_descuento = 1 THEN 'CONTADO' 
                        WHEN DC.tipo_descuento = 2 THEN 'CRÉDITO' 
                        ELSE 'Otro' 
                    END AS tipo_pago
                FROM clientes AS C
                INNER JOIN descuento_cliente AS DC ON C.id = DC.cliente_id
                INNER JOIN productos AS P ON P.id = DC.id_combustible
                WHERE C.empresa_id = $empresaId AND C.sucursal_id = $sucursalId
                ORDER BY C.nombre ASC";
            break;
        case 3: // ADELANTOS DE CLIENTES
            $titulo = 'REPORTE DE CLIENTES CON ADELANTOS';
            $sql = "SELECT C.id, C.nombre, AC.importe_adelantado AS adelantado, AC.importe_consumido AS consumido
                    FROM clientes AS C
                    INNER JOIN adelanto_cliente AS AC ON C.id = AC.cliente_id
                    WHERE C.empresa_id = $empresaId AND C.sucursal_id = $sucursalId
                    ORDER BY C.nombre ASC";
            break;
        default:
            throw new Exception("Tipo de informe no válido.");
    }

    $stmt = $conn->prepare($sql);
    $stmt->execute();
    $datosReporte = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($datosReporte)) {
        throw new Exception("No se encontraron datos para el reporte solicitado.");
    }

    // Crear el PDF
    $pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetMargins(10, 10, 10);
    $pdf->SetAutoPageBreak(true, 10);
    $pdf->SetDisplayMode(100, 'SinglePage');
    $pdf->AddPage();

    $logo_path = '../../tcpdf/logos/10278514876.png';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }
    $pdf->Ln(18);

    // Cabecera
    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, $titulo, 0, 1, 'C');
    $pdf->Ln(5);

    // Tabla según el tipo de informe
    $pdf->SetFillColor(5, 152, 172);       // Fondo celeste oscuro
    $pdf->SetTextColor(255, 255, 255);     // Letras blancas
    $pdf->SetDrawColor(0, 0, 0);           // Borde negro
    $pdf->SetFont('helvetica', 'B', 10);

    if ($tipoInforme == 0) {
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(15, 8, 'ID', 1, 0, 'C', true);
        $pdf->Cell(95, 8, 'Cliente', 1, 0, 'C', true);
        $pdf->Cell(50, 8, 'Dirección', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Teléfono', 1, 1, 'C', true); 

        $pdf->SetTextColor(0, 0, 0);
    
        $pdf->SetFont('helvetica', '', 8);
    
        foreach ($datosReporte as $row) {
            $pdf->Cell(15, 7, $row['id'], 1, 0, 'C');
            $pdf->Cell(95, 7, utf8_decode(mb_substr($row['nombre'], 0, 54)), 1, 0, 'L');
            $pdf->Cell(50, 7, utf8_decode(mb_substr($row['direccion'], 0, 29)), 1, 0, 'L');
            $pdf->Cell(30, 7, utf8_decode($row['telefono1']), 1, 1, 'L'); 
        }
    } elseif ($tipoInforme == 1) {
        // Tabla para clientes
        $pdf->Cell(15, 8, 'ID', 1, 0, 'C', true);
        $pdf->Cell(120, 8, 'Cliente', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Importe Max', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Consumido', 1, 1, 'C', true);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->SetFont('helvetica', '', 8);

        foreach ($datosReporte as $row) {
            $pdf->Cell(15, 7, $row['id'], 1, 0, 'C');
            $pdf->Cell(120, 7, utf8_decode($row['nombre']), 1, 0, 'L');
            $pdf->Cell(30, 7, number_format($row['importe_maximo'], 2), 1, 0, 'R');
            $pdf->Cell(30, 7, number_format($row['importe_consumido'], 2), 1, 1, 'R');
        }
    } elseif ($tipoInforme == 2) {
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(15, 8, 'ID', 1, 0, 'C', true);
        $pdf->Cell(80, 8, 'Cliente', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Producto', 1, 0, 'C', true);
        $pdf->Cell(20, 8, 'Descuento', 1, 0, 'C', true);
        $pdf->Cell(20, 8, 'Cantidad', 1, 0, 'C', true);
        $pdf->Cell(25, 8, 'Tipo Pago', 1, 1, 'C', true);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->SetFont('helvetica', '', 8);

        foreach ($datosReporte as $row) {
            $pdf->Cell(15, 7, $row['id'], 1, 0, 'C');
            $pdf->Cell(80, 7, utf8_decode($row['nombre']), 1, 0, 'L');
            $pdf->Cell(30, 7, utf8_decode($row['producto']), 1, 0, 'L');
            $pdf->Cell(20, 7, number_format($row['descuento'], 2), 1, 0, 'R');
            $pdf->Cell(20, 7, number_format($row['cantidad'], 2), 1, 0, 'R');
            $pdf->Cell(25, 7, $row['tipo_pago'], 1, 1, 'C');
        }
    } elseif ($tipoInforme == 3) {
        // Tabla para adelantos
        $pdf->Cell(15, 8, 'ID', 1, 0, 'C', true);
        $pdf->Cell(120, 8, 'Cliente', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Adelantado', 1, 0, 'C', true);
        $pdf->Cell(30, 8, 'Consumido', 1, 1, 'C', true);

        $pdf->SetTextColor(0, 0, 0);

        $pdf->SetFont('helvetica', '', 10);

        foreach ($datosReporte as $row) {
            $pdf->Cell(15, 7, $row['id'], 1, 0, 'C');
            $pdf->Cell(120, 7, utf8_decode($row['nombre']), 1, 0, 'L');
            $pdf->Cell(30, 7, number_format($row['adelantado'], 2), 1, 0, 'R');
            $pdf->Cell(30, 7, number_format($row['consumido'], 2), 1, 1, 'R');
        }
    }

    // Output del PDF
    $pdf->Output('reporte_clientes.pdf', 'I');

} catch (Exception $e) {
    http_response_code(500); // IMPORTANTE
    header("Content-Type: application/json; charset=utf-8"); // CORRIGE tipo de respuesta
    
    error_log("ERROR: " . $e->getMessage());
    echo json_encode([
        "estado" => "0",
        "mensaje" => $e->getMessage()
    ]);
}
?>
