<?php
include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

if (isset($_GET['ping'])) { header('Content-Type: text/plain'); echo 'OK'; exit; }

/* ========= INPUT ========= */
$payload = json_decode(file_get_contents('php://input'), true) ?: [];
$items   = $payload['items'] ?? [];
if (!$items) { http_response_code(400); die('JSON inválido'); }

/* ========= PARAMS 30x20 (2 columnas) ========= */
$COLUMNS = 2;
$LABEL_W = 30;   // mm
$LABEL_H = 20;   // mm
$GAP_X   = 2;    // mm (entre columnas)
$GAP_Y   = 2;    // mm (entre filas)

/* Offsets y debug */
$START_COL   = max(0, min($COLUMNS-1, (int)($payload['start_col'] ?? 0)));
$START_ROW   = max(0, (int)($payload['start_row'] ?? 0));
$OFFSET_X    = (float)($payload['mm_left_offset'] ?? 0);
$OFFSET_Y    = (float)($payload['mm_top_offset']  ?? 0);
$DRAW_BORDER = !empty($payload['debug']);

/* Paginación: por defecto activamos “página larga” */
$LONG_PAGE      = isset($payload['long_page']) ? (bool)$payload['long_page'] : true;
$ROWS_PER_PAGE  = (int)($payload['rows_per_page'] ?? 6);   // usado solo si $LONG_PAGE=false
if ($ROWS_PER_PAGE < 1) $ROWS_PER_PAGE = 6;

/* Márgenes en rollo */
$MARGIN_L = 0; $MARGIN_R = 0; $MARGIN_T = 0; $MARGIN_B = 0;

/* ========= DPI y helper: alinear a “dots” ========= */
$DPI = (int)($payload['dpi'] ?? 203);      // 203 típico Zebra/TSC
$DOT_STEP = 25.4 / max(1, $DPI);           // mm por dot
$toDot = function($mm) use ($DOT_STEP) { return round($mm / $DOT_STEP) * $DOT_STEP; };

/* Alinear medidas */
$LABEL_W = $toDot($LABEL_W);
$LABEL_H = $toDot($LABEL_H);
$GAP_X   = $toDot($GAP_X);
$GAP_Y   = $toDot($GAP_Y);
$MARGIN_L = $toDot($MARGIN_L);
$MARGIN_R = $toDot($MARGIN_R);
$MARGIN_T = $toDot($MARGIN_T);
$MARGIN_B = $toDot($MARGIN_B);

$OFFSET_X = $toDot($OFFSET_X);
$OFFSET_Y = $toDot($OFFSET_Y);

/* ========= CÁLCULO DE TAMAÑOS ========= */
$PAGE_W = $toDot($COLUMNS * $LABEL_W + ($COLUMNS - 1) * $GAP_X + $MARGIN_L + $MARGIN_R);

/* Contar total de etiquetas (con START_ROW/COL) para “página larga” */
$labelsPerRow   = $COLUMNS;
$printedStart   = ($START_ROW * $labelsPerRow) + $START_COL;
$totalQty       = 0;
foreach ($items as $it) { $q = (int)($it['qty'] ?? 0); if ($q > 0) $totalQty += $q; }
$totalPositions = $printedStart + $totalQty;
$totalRows      = (int)ceil($totalPositions / $labelsPerRow);

/* Límite sano de altura de página (por si el driver tiene tope) */
$MAX_PAGE_H_MM = (float)($payload['max_page_mm'] ?? 800.0);  // 800mm ≈ seguro
$unitRow       = ($LABEL_H + $GAP_Y);                        // alto de una fila + gap

if ($LONG_PAGE) {
    /* -------- MODO PÁGINA LARGA -------- */
    if ($totalRows < 1) $totalRows = 1;
    //$PAGE_H0 = $MARGIN_T + $MARGIN_B + ($totalRows * $LABEL_H) + (($totalRows - 1) * $GAP_Y);
    //$PAGE_H  = $toDot(min($PAGE_H0, $MAX_PAGE_H_MM));  // tope por seguridad
    
    $EJECT_EXTRA_MM = (float)($payload['eject_extra_mm'] ?? 2.0); // << nuevo
    $PAGE_H0 = $MARGIN_T + $MARGIN_B
             + ($totalRows * $LABEL_H)
             + (($totalRows - 1) * $GAP_Y);
    
    // Sumamos un pequeño “feed” al final
    $PAGE_H  = $toDot(min($PAGE_H0 + $EJECT_EXTRA_MM, $MAX_PAGE_H_MM));

    $pdf = new TCPDF('P', 'mm', array($PAGE_W, $PAGE_H), true, 'UTF-8', false);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->SetMargins($MARGIN_L, $MARGIN_T, $MARGIN_R);
    $pdf->SetAutoPageBreak(false, 0);
    $pdf->SetDisplayMode('real', 'OneColumn');
    $pdf->setViewerPreferences([
        'FitWindow'=>true,'CenterWindow'=>true,'DisplayDocTitle'=>true,
        'NonFullScreenPageMode'=>'UseNone','PrintScaling'=>'None',
        'ViewArea'=>'CropBox','ViewClip'=>'CropBox','PrintArea'=>'CropBox','PrintClip'=>'CropBox'
    ]);
    $pdf->AddPage();

    $printed = $printedStart; // ya considera start_row/col
    foreach ($items as $it) {
        $qty = (int)($it['qty'] ?? 0); if ($qty <= 0) continue;
        for ($i = 0; $i < $qty; $i++) {
            $pos = $printed;                    // en página única no hay %labelsPerPage
            $row = (int)floor($pos / $labelsPerRow);
            $col = $pos % $labelsPerRow;

            $x = $col * ($LABEL_W + $GAP_X) + $OFFSET_X + $MARGIN_L;
            $y = $row * ($LABEL_H + $GAP_Y) + $OFFSET_Y + $MARGIN_T;

            drawLabel($pdf, $x, $y, $LABEL_W, $LABEL_H, $it, $DRAW_BORDER);
            $printed++;
        }
    }

} else {
    /* -------- MODO CLÁSICO POR PÁGINAS -------- */
    //$PAGE_H0 = $MARGIN_T + $MARGIN_B + ($ROWS_PER_PAGE * $LABEL_H) + (($ROWS_PER_PAGE - 1) * $GAP_Y);
    //$PAGE_H  = $toDot(min($PAGE_H0, $MAX_PAGE_H_MM));
    
    $EJECT_EXTRA_MM = (float)($payload['eject_extra_mm'] ?? 0.0);
    $PAGE_H0 = $MARGIN_T + $MARGIN_B
             + ($ROWS_PER_PAGE * $LABEL_H)
             + (($ROWS_PER_PAGE - 1) * $GAP_Y);
    $PAGE_H  = $toDot(min($PAGE_H0 + $EJECT_EXTRA_MM, $MAX_PAGE_H_MM));

    $pdf = new TCPDF('P', 'mm', array($PAGE_W, $PAGE_H), true, 'UTF-8', false);
    $pdf->setPrintHeader(false);
    $pdf->setPrintFooter(false);
    $pdf->SetMargins($MARGIN_L, $MARGIN_T, $MARGIN_R);
    $pdf->SetAutoPageBreak(false, 0);
    $pdf->SetDisplayMode('real', 'OneColumn');
    $pdf->setViewerPreferences([
        'FitWindow'=>true,'CenterWindow'=>true,'DisplayDocTitle'=>true,
        'NonFullScreenPageMode'=>'UseNone','PrintScaling'=>'None',
        'ViewArea'=>'CropBox','ViewClip'=>'CropBox','PrintArea'=>'CropBox','PrintClip'=>'CropBox'
    ]);
    $pdf->AddPage();

    $labelsPerPage = $labelsPerRow * $ROWS_PER_PAGE;
    $printed = $printedStart;

    foreach ($items as $it) {
        $qty = (int)($it['qty'] ?? 0); if ($qty <= 0) continue;
        for ($i = 0; $i < $qty; $i++) {
            if ($printed > 0 && ($printed % $labelsPerPage) === 0) {
                $pdf->AddPage();
            }
            $pos = $printed % $labelsPerPage;
            $row = (int)floor($pos / $labelsPerRow);
            $col = $pos % $labelsPerRow;

            $x = $col * ($LABEL_W + $GAP_X) + $OFFSET_X + $MARGIN_L;
            $y = $row * ($LABEL_H + $GAP_Y) + $OFFSET_Y + $MARGIN_T;

            drawLabel($pdf, $x, $y, $LABEL_W, $LABEL_H, $it, $DRAW_BORDER);
            $printed++;
        }
    }
}

/* ========= DIBUJO DE ETIQUETA ========= */
function drawLabel(TCPDF $pdf, $x, $y, $w, $h, $item, $drawBorder=false) {
    if ($drawBorder) { $pdf->SetDrawColor(200,200,200); $pdf->Rect($x, $y, $w, $h); }

    // Márgenes y alturas
    $pad       = 0.9;      // padding superior/izquierdo/derecho
    $gap       = 0.4;      // espacio entre bloques
    $lineH     = 3.0;      // alto por línea del nombre
    $maxLines  = 2;        // 1–2 líneas
    $priceH    = 4.6;      // alto visual del precio

    // === equilibrio de márgenes ===
    $BOTTOM_SAFE = $pad;   // mismo margen inferior que el superior
    $barcodeH    = 7.0;    // un poco más bajo para no rozar

    // ===== Nombre (centrado, 1–2 líneas)
    $nombre = trim($item['descripcion'] ?? '');
    $pdf->SetFont('helvetica','B',5.9);
    $innerW = $w - 2*$pad;

    $numLines = max(1, min($maxLines, $pdf->getNumLines($nombre, $innerW)));
    $nameH    = $numLines * $lineH;

    $nameY = $y + $pad;
    $pdf->SetXY($x + $pad, $nameY);
    $pdf->MultiCell($innerW, $nameH, $nombre, 0, 'C', false, 0, '', '', true, 0, false, true, $nameH, 'T');

    // ===== Barcode anclado abajo con margen igual al superior
    $barcodeY = $y + $h - $barcodeH - $BOTTOM_SAFE;

    // ===== Precio centrado entre nombre y barcode
    $precioRaw = $item['precio'] ?? ($item['precio_str'] ?? null);
    if ($precioRaw !== null && $precioRaw !== '') {
        $precioTxt = is_numeric($precioRaw)
            ? ('S/ ' . number_format((float)$precioRaw, 2, '.', ''))
            : (stripos(trim((string)$precioRaw),'s/') === false ? 'S/ '.trim((string)$precioRaw) : trim((string)$precioRaw));

        $zonaTop = $nameY + $nameH + $gap;
        $zonaBot = $barcodeY;
        $priceY  = $zonaTop + max(0, (($zonaBot - $zonaTop) - $priceH) / 2);
        $priceY  = min($priceY, $barcodeY - $priceH - 0.5);

        $pdf->SetFont('helvetica','B',12);
        $pdf->SetXY($x + $pad, $priceY);
        $pdf->Cell($innerW, $priceH, $precioTxt, 0, 0, 'C', false);
    }

    // ===== Código de barras (centrado, ancho fijo)
    $valorBarcode = trim($item['codigo_barras'] ?? ($item['id'] ?? ''));
    if ($valorBarcode === '') { $valorBarcode = '000000'; }

    $BAR_SIDE_MARGIN = 3.0;                        // margen lateral
    $BAR_W = max(8.0, $w - 2*$BAR_SIDE_MARGIN);    // bloque fijo
    $bx = $x + ($w - $BAR_W) / 2.0;

    $style = [
        'position'=>'', 'align'=>'C',
        'stretch'=>false, 'fitwidth'=>false,
        'border'=>false, 'hpadding'=>0, 'vpadding'=>0,
        'fgcolor'=>[0,0,0], 'bgcolor'=>false,
        'text'=>true, 'font'=>'helvetica', 'fontsize'=>4.8
    ];

    $pdf->SetFont('helvetica','',4.8);  // por si el estilo no lo aplica
    $pdf->write1DBarcode($valorBarcode, 'C128', $bx, $barcodeY, $BAR_W, $barcodeH, 0.32, $style, 'N');
}

/*function drawLabel(TCPDF $pdf, $x, $y, $w, $h, $item, $drawBorder=false) {
    if ($drawBorder) { $pdf->SetDrawColor(200,200,200); $pdf->Rect($x, $y, $w, $h); }

    // ---- layout básico ----
    $pad        = 0.8;      // margen interno
    $gap        = 0.4;      // espacio entre bloques
    $descLineH  = 3.0;      // alto por línea de descripción
    $descLines  = 2;        // máx líneas
    $descMaxH   = $descLines * $descLineH;

    $priceH     = 4.2;      // alto de caja de precio
    $barcodeH   = 7.0;      // (antes 7.6) un paso más bajo

    // ---- Descripción (centrada, 2 líneas máx) ----
    $desc = trim($item['descripcion'] ?? '');
    $pdf->SetFont('helvetica','B',5.8);      // (antes 6.2) letras un poco más chicas
    $descY = $y + $pad;
    $pdf->SetXY($x + $pad, $descY);
    $pdf->MultiCell($w - 2*$pad, $descLineH, $desc,
        0, 'C', false, 0, '', '', true, 0, false, true, $descMaxH, 'T');

    // ---- Precio ----
    $basePriceY = $descY + $descMaxH + $gap;
    $PRICE_SHIFT_UP = 0.8;
    $MIN_GAP_ABOVE  = 0.2;
    $priceY = max($descY + $descMaxH + $MIN_GAP_ABOVE, $basePriceY - $PRICE_SHIFT_UP);

    // ---- Posición Y del barcode ----
    $barcodeY = $y + $h - $barcodeH - 1.2;
    $MIN_GAP_BELOW = 0.6;
    if ($priceY + $priceH + $MIN_GAP_BELOW > $barcodeY) {
        $priceY = $barcodeY - $priceH - $MIN_GAP_BELOW;
    }

    // ---- Dibuja precio (centrado) ----
    $precioRaw = $item['precio'] ?? ($item['precio_str'] ?? null);
    if ($precioRaw !== null && $precioRaw !== '') {
        $precioTxt = is_numeric($precioRaw)
            ? ('S/ ' . number_format((float)$precioRaw, 2, '.', ''))
            : (stripos(trim((string)$precioRaw),'s/') === false ? 'S/ '.trim((string)$precioRaw) : trim((string)$precioRaw));
        $pdf->SetFont('helvetica','B',12);
        $pdf->SetXY($x + $pad, $priceY);
        $pdf->Cell($w - 2*$pad, $priceH, $precioTxt, 0, 0, 'C', false);
    }

    // ---- Código de barras (CENTRADO y un punto más angosto) ----
    $valorBarcode = trim($item['codigo_barras'] ?? ($item['id'] ?? ''));
    if ($valorBarcode === '') { $valorBarcode = '000000'; }

    // deja ~3mm de margen a cada lado y centra el bloque
    $BAR_SIDE_MARGIN = 3.0;
    $BAR_W = max(8.0, $w - 2*$BAR_SIDE_MARGIN);          // ancho fijo del bloque
    $bx = $x + ($w - $BAR_W) / 2.0;                       // <-- centrado horizontal real

    $style = [
        'position'=>'', 'align'=>'C',
        'stretch'=>false, 'fitwidth'=>false,              // <-- NO estirar a todo el ancho
        'border'=>false, 'hpadding'=>0, 'vpadding'=>0,
        'fgcolor'=>[0,0,0], 'bgcolor'=>false,
        'text'=>true
    ];

    $pdf->SetFont('helvetica','',5.0);                    // (antes 6.0) texto del código más pequeño
    $pdf->write1DBarcode($valorBarcode, 'C128',
                         $bx, $barcodeY, $BAR_W, $barcodeH,
                         0.32,                                        // (antes 0.35) barras un paso más finas
                         $style, 'N');
}*/

/*function drawLabel(TCPDF $pdf, $x, $y, $w, $h, $item, $drawBorder=false) {
    if ($drawBorder) { $pdf->SetDrawColor(200,200,200); $pdf->Rect($x, $y, $w, $h); }

    $pad        = 0.8;   $gap = 0.4;
    $descLineH  = 3.0;   $descLines = 2;  $descMaxH = $descLines * $descLineH;
    $priceH     = 4.2;   $barcodeH  = 7.6;

    // Descripción (máx 2 líneas, centrado)
    $desc = trim($item['descripcion'] ?? '');
    $pdf->SetFont('helvetica','B',6.2);
    $descY = $y + $pad;
    $pdf->SetXY($x + $pad, $descY);
    $pdf->MultiCell($w - 2*$pad, $descLineH, $desc,
        0, 'C', false, 0, '', '', true, 0, false, true, $descMaxH, 'T');

    // Precio (ligeramente arriba)
    $basePriceY = $descY + $descMaxH + $gap;
    $PRICE_SHIFT_UP = 0.8; $MIN_GAP_ABOVE = 0.2;
    $priceY = max($descY + $descMaxH + $MIN_GAP_ABOVE, $basePriceY - $PRICE_SHIFT_UP);

    // Código de barras
    $barcodeY = $y + $h - $barcodeH - 1.2;
    $MIN_GAP_BELOW = 0.6;
    if ($priceY + $priceH + $MIN_GAP_BELOW > $barcodeY) {
        $priceY = $barcodeY - $priceH - $MIN_GAP_BELOW;
    }

    $precioRaw = $item['precio'] ?? ($item['precio_str'] ?? null);
    if ($precioRaw !== null && $precioRaw !== '') {
        $precioTxt = is_numeric($precioRaw)
            ? ('S/ ' . number_format((float)$precioRaw, 2, '.', ''))
            : (stripos(trim((string)$precioRaw),'s/') === false ? 'S/ '.trim((string)$precioRaw) : trim((string)$precioRaw));
        $pdf->SetFont('helvetica','B',12);
        $pdf->SetXY($x + $pad, $priceY);
        $pdf->Cell($w - 2*$pad, $priceH, $precioTxt, 0, 0, 'C', false);
    }

    $valorBarcode = trim($item['codigo_barras'] ?? ($item['id'] ?? ''));
    if ($valorBarcode === '') { $valorBarcode = '000000'; }
    $style = [
        'position'=>'', 'align'=>'C', 'stretch'=>false, 'fitwidth'=>true,
        'border'=>false, 'hpadding'=>0, 'vpadding'=>0, 'fgcolor'=>[0,0,0],
        'bgcolor'=>false, 'text'=>true
    ];
    $pdf->SetFont('helvetica','',6.0);
    $pdf->write1DBarcode($valorBarcode, 'C128', $x+1, $barcodeY, $w-2, $barcodeH, 0.35, $style, 'N');
}*/

/* ========= OUTPUT ========= */
$pdfContent = $pdf->Output('etiquetas_30x20_2col.pdf', 'S');
header('Content-Type: application/pdf');
header('Content-Disposition: inline; filename="etiquetas_30x20_2col.pdf"');
header('Content-Length: ' . strlen($pdfContent));
echo $pdfContent;