<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $datos = json_decode(file_get_contents("php://input"), true);
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos. Se esperaba: [anio, semana, usuario].");
    }

    $anio = (int)$datos[0];
    $semana = (int)$datos[1];
    $usuario = $datos[2];

    $sql = "SELECT * FROM estadisticas_turno_por_semana(:anio, :semana) ORDER BY fecha, tipo";
    $stmt = $conn->prepare($sql);
    $stmt->execute([':anio' => $anio, ':semana' => $semana]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        throw new Exception("No hay datos disponibles para la semana indicada.");
    }

    $agrupado = [];
    foreach ($rows as $row) {
        $fecha = $row['fecha'];
        $agrupado[$fecha][] = $row;
    }

    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetMargins(10, 10, 10);
    $pdf->AddPage();

    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, 'ESTADISTICA SEMANAL DE TURNOS', 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 6, "Semana: $semana - Año: $anio", 0, 1, 'C');
    $pdf->Cell(0, 6, "Usuario: $usuario", 0, 1, 'C');

    foreach ($agrupado as $fecha => $items) {
        $pdf->Ln(5);
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->Cell(0, 7, "Fecha: $fecha", 0, 1, 'L');

        $pdf->SetFont('helvetica', 'B', 9);
        $pdf->SetFillColor(240, 240, 240);
        $pdf->Cell(30, 7, 'Tipo', 1, 0, 'C', 1);
        $pdf->Cell(40, 7, 'Subtipo', 1, 0, 'C', 1);
        $pdf->Cell(90, 7, 'Descripcion', 1, 0, 'C', 1);
        $pdf->Cell(30, 7, 'Cantidad', 1, 0, 'C', 1);
        $pdf->Cell(30, 7, 'Importe (S/)', 1, 1, 'C', 1);

        $pdf->SetFont('helvetica', '', 9);
        foreach ($items as $item) {
            $pdf->Cell(30, 6, $item['tipo'], 1);
            $pdf->Cell(40, 6, $item['subtipo'], 1);
            $pdf->Cell(90, 6, $item['descripcion'], 1);
            $pdf->Cell(30, 6, number_format($item['cantidad'] ?? 0, 3), 1, 0, 'R');
            $pdf->Cell(30, 6, number_format($item['importe'], 2), 1, 1, 'R');
        }
    }

    $pdf->Ln(10);
    $pdf->SetFont('helvetica', '', 9);
    $pdf->Cell(0, 6, '___________________________', 0, 1, 'L');
    $pdf->Cell(0, 6, 'Firma Responsable', 0, 1, 'L');

    $pdf->Output('estadistica_turno_semanal.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR capturado: " . $e->getMessage());
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}
