<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . '/../../tcpdf/tcpdf.php';
include_once __DIR__ . '/../../conexion.php';

header("Content-Type: application/pdf; charset=utf-8");

$datos = json_decode(file_get_contents("php://input"), true);
$turno_id = isset($datos[0]) ? (int)$datos[0] : 0;

if ($turno_id <= 0) {
    throw new Exception("ID de turno inválido.");
}

// Obtener datos del reporte
$stmt = $conn->prepare("SELECT * FROM public.liquidacion_turno_por_vendedor(:turno_id)");
$stmt->bindParam(':turno_id', $turno_id, PDO::PARAM_INT);
$stmt->execute();
$datosReporte = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Inicializar TCPDF
$pdf = new TCPDF('P', 'mm', 'A4', true, 'UTF-8', false);
$pdf->SetCreator('SICSE');
$pdf->SetAuthor('Sistema');
$pdf->SetTitle('Liquidación Turno por Vendedor');
$pdf->SetMargins(10, 10, 10);
$pdf->AddPage();
$pdf->SetFont('helvetica', '', 9);

$actualVendedor = null;

foreach ($datosReporte as $fila) {
    $vendedorId = $fila['vendedor_id'];
    $vendedorNombre = $fila['vendedor_nombre'];
    $categoria = $fila['categoria'];
    $subcategoria = $fila['subcategoria'];
    $descripcion = $fila['descripcion'];
    $cantidad = $fila['cantidad'];
    $importe = $fila['importe'];

    // Si cambia el vendedor, nuevo bloque
    if ($vendedorId !== 0 && $actualVendedor !== $vendedorId) {
        if ($actualVendedor !== null) {
            $pdf->Ln(5);
            $pdf->AddPage();
        }
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->Cell(0, 10, "VENDEDOR: $vendedorNombre", 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 9);
        $pdf->SetFillColor(200, 200, 200);
        $pdf->Cell(35, 8, 'CATEGORIA', 1, 0, 'C', 1);
        $pdf->Cell(35, 8, 'SUBCATEGORIA', 1, 0, 'C', 1);
        $pdf->Cell(60, 8, 'DESCRIPCION', 1, 0, 'C', 1);
        $pdf->Cell(25, 8, 'CANTIDAD', 1, 0, 'C', 1);
        $pdf->Cell(30, 8, 'IMPORTE', 1, 1, 'C', 1);
        $pdf->SetFont('helvetica', '', 9);
        $actualVendedor = $vendedorId;
    }

    if ($vendedorId !== 0) {
        $pdf->Cell(35, 8, $categoria, 1);
        $pdf->Cell(35, 8, $subcategoria, 1);
        $pdf->Cell(60, 8, $descripcion, 1);
        $pdf->Cell(25, 8, is_numeric($cantidad) ? number_format($cantidad, 3) : '', 1, 0, 'R');
        $pdf->Cell(30, 8, is_numeric($importe) ? 'S/ ' . number_format($importe, 2) : '', 1, 1, 'R');
    }
}

// Agregar resumen general
$pdf->Ln(10);
$pdf->SetFont('helvetica', 'B', 12);
$pdf->Cell(0, 10, 'RESUMEN GENERAL DEL TURNO', 0, 1, 'L');
$pdf->SetFont('helvetica', 'B', 9);
$pdf->SetFillColor(220, 220, 220);
$pdf->Cell(40, 8, 'CATEGORIA', 1, 0, 'C', 1);
$pdf->Cell(40, 8, 'SUBCATEGORIA', 1, 0, 'C', 1);
$pdf->Cell(70, 8, 'DESCRIPCION', 1, 0, 'C', 1);
$pdf->Cell(30, 8, 'IMPORTE', 1, 1, 'C', 1);

$pdf->SetFont('helvetica', '', 9);

foreach ($datosReporte as $fila) {
    if ((int)$fila['vendedor_id'] === 0) {
        $pdf->Cell(40, 8, $fila['categoria'], 1);
        $pdf->Cell(40, 8, $fila['subcategoria'], 1);
        $pdf->Cell(70, 8, $fila['descripcion'], 1);
        $pdf->Cell(30, 8, 'S/ ' . number_format($fila['importe'], 2), 1, 1, 'R');
    }
}

$pdf->Output("liquidacion_turno_detallado.pdf", "I");
