<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");
//header("Content-Type: text/plain; charset=utf-8");

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5])) {
        throw new Exception("Parámetros incompletos.");
    }

    $turno_id = (int)$datos[0];
    $empleado_id = (int)$datos[1];
    //$caja_id = (int)$datos[2];
    //$nombre_vendedor = $datos[3] ?? 'Vendedor';
    $nombre_turno = $datos[2] ?? 'MAÑANA';
    $modo = $datos[3] ?? 'vista';
    $fecha_turno = $datos[4];
    $usuario = $datos[5] ?? 'Usuario';

    $sql = "SELECT * FROM liquidacion_turno_general(:turno_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id
    ]);

    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($resultados)) {
        throw new Exception("No se encontraron registros.");
    }

    class MYPDF extends TCPDF {
        public function Header() {
            $logo_path = __DIR__ . '/../../tcpdf/logos/10278514876.png';
            if (file_exists($logo_path)) {
                $this->Image($logo_path, 10, 5, 30, 15, '', '', 'T', false, 300);
            }
            $this->Ln(18); // Espacio después del logo
        }
    }

    $pdf = new MYPDF('P', 'mm', 'A4', true, 'UTF-8', false);

    $pdf->SetMargins(20, 10, 10);
    $pdf->SetAutoPageBreak(true, 0); // ✔ Ajuste para evitar espacio final excesivo
    $pdf->AddPage();
    $pdf->SetDisplayMode(100, 'SinglePage');

    /*$logo_path = '../../tcpdf/logos/10278514876.png';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }
    $pdf->Ln(18);*/

    $fecha = date('d/m/Y');
    $hora = date('H:i:s');

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(0, 6, 'LIQUIDACION POR TURNO', 0, 1, 'C');
    $pdf->Ln(2);

    $tamFuente = ($modo === 'impresion') ? 9 : 8;
    $pdf->SetFont('helvetica', '', $tamFuente);
    $pdf->Cell(0, 5, "Fecha: {$fecha_turno}    Turno: {$nombre_turno}", 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 7);
    //$pdf->Cell(0, 5, "VENDEDOR: {$nombre_vendedor}", 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 8);
    //$pdf->Ln(2);

    $lecturasGalones = [];
    $lecturasSoles = [];
    $despachos = [];
    $pagos = [];
    $detalleCobranza = [];
    $detalleIngresos = [];
    $detalleBoveda = [];
    $detalleEgresos = [];
    $totales = [];
    $porentregar = [];
    $tituloPagos = false;
    $telemetria = [];
    $comparativoGalones = [];
    $comparativoSoles = [];

    foreach ($resultados as $row) {
        switch ($row['tipo']) {
            case 'LECTURA_GALONES': $lecturasGalones[] = $row; break;
            case 'LECTURA_SOLES': $lecturasSoles[] = $row; break;
            case 'SUBREPORTE_COMBUSTIBLE': $despachos[] = $row; break;
            case 'DETALLE COBRANZA': $detalleCobranza[] = $row; break;
            case 'DETALLE INGRESOS': $detalleIngresos[] = $row; break;
            case 'DETALLE BOVEDA': $detalleBoveda[] = $row; break;
            case 'DETALLE EGRESOS': $detalleEgresos[] = $row; break;
            case 'VENTAS': $totales[] = $row; break;
            case 'TITULO_PAGO_ELECTRONICO': $tituloPagos = true; break;
            case 'DETALLE_PAGO_ELECTRONICO': $pagos[] = $row; break;
            case 'SALDO FINAL': $porentregar[] = $row; break;
            case 'TELEMETRIA': $telemetria[] = $row; break;
            case 'COMPARATIVO_GALONES': $comparativoGalones[] = $row; break;
            case 'COMPARATIVO_SOLES': $comparativoSoles[] = $row; break;
        }
    }

    function imprimirLineaPuntos($pdf, $titulo, $monto) {
        $pdf->Cell(57, 4, $titulo, 0, 0, 'L');
        $pdf->Cell(15, 4, number_format($monto ?? 0, 2), 0, 1, 'R');
    }

    function imprimirLineaPuntosPequenos($pdf, $titulo, $monto) {
        $pdf->Cell(50, 4, $titulo, 0, 0, 'L');
        $pdf->Cell(15, 4, number_format($monto ?? 0, 2), 0, 1, 'R');
    }

    // --- LECTURAS GALONES ---
    if (count($lecturasGalones) > 0) {
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'CONTOMETROS  GALONES', 0, 1, 'C');
    
        $pdf->SetFont('helvetica', '', 7);
        $currentCara = null;
    
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(0, 3, '', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(18, 4, 'MANGUERA', 0, 0, 'L');
        $pdf->Cell(35, 4, 'COMBUSTIBLE', 0, 0, 'L');
        $pdf->Cell(30, 4, 'LECTURA FINAL', 0, 0, 'C');
        $pdf->Cell(30, 4, 'LECTURA INICIAL', 0, 0, 'C');
        $pdf->Cell(30, 4, 'TOTAL', 0, 1, 'C');
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        foreach ($lecturasGalones as $row) {
            // Agrupamos por CARA
            if ($row['cara'] !== $currentCara) {
                $currentCara = $row['cara'];
                //$pdf->Ln(1);
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(0, 4, 'CARA ' . $currentCara, 0, 1, 'L');
                $pdf->SetFont('helvetica', '', 7);
            }

            $pdf->Cell(10, 4, $row['manguera'], 0, 0, 'R');
            $pdf->Cell(8, 4, '', 0, 0); 
            $pdf->Cell(35, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(30, 4, number_format($row['lectura_final'] ?? 0, 3), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['lectura_inicial'] ?? 0, 3), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 3), 0, 1, 'R');
        }
        //$pdf->Ln(2);
    }

    // --- LECTURAS SOLES ---
    if (count($lecturasSoles) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'CONTOMETROS  SOLES', 0, 1, 'C');
    
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(0, 3, '', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(18, 4, 'MANGUERA', 0, 0, 'L');
        $pdf->Cell(35, 4, 'COMBUSTIBLE', 0, 0, 'L');
        $pdf->Cell(30, 4, 'LECTURA FINAL', 0, 0, 'C');
        $pdf->Cell(30, 4, 'LECTURA INICIAL', 0, 0, 'C');
        $pdf->Cell(30, 4, 'TOTAL', 0, 1, 'C');
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        $currentCara = null;
    
        foreach ($lecturasSoles as $row) {
            if ($row['cara'] !== $currentCara) {
                $currentCara = $row['cara'];
                //$pdf->Ln(1);
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(0, 4, 'CARA ' . $currentCara, 0, 1, 'L');
            }
            $pdf->SetFont('helvetica', '', 7);
            $pdf->Cell(10, 4, $row['manguera'], 0, 0, 'R');
            $pdf->Cell(8, 4, '', 0, 0); 
            $pdf->Cell(35, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(30, 4, number_format($row['lectura_final'] ?? 0, 2), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['lectura_inicial'] ?? 0, 2), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
        }
    
        //$pdf->Ln(2);
    }

    // --- DESPACHOS COMBUSTIBLE ---
    if (count($despachos) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->SetX(53);
        $pdf->Cell(0, 4, 'RESUMEN DESPACHOS COMBUSTIBLE', 0, 1, 'L');
        $pdf->Cell(0, 3, '', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->SetX(45);
        $pdf->Cell(22, 4, 'COMBUSTIBLE', 0, 0, 'L');
        $pdf->Cell(18, 4, 'PRECIO', 0, 0, 'C');
        $pdf->Cell(18, 4, 'GALONES', 0, 0, 'C');
        $pdf->Cell(18, 4, 'SOLES', 0, 1, 'C');
        $pdf->SetX(45);
        $pdf->Cell(0, 3, '----------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', '', 7);

        foreach ($despachos as $row) {
            $descripcion = $row['descripcion'] ?? '-';
            $lectura_inicial = $row['lectura_inicial'] ?? 0;
            $lectura_final = $row['lectura_final'] ?? 0;
            $importe = $row['importe'] ?? 0;

            $pdf->SetX(45);
            $pdf->Cell(18, 4, $descripcion, 0, 0, 'L');
            $pdf->Cell(18, 4, number_format($lectura_inicial, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($lectura_final, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($importe, 2), 0, 1, 'R');
        }
        //$pdf->Ln(2);
    }

    // --- TELEMETRÍA ---
    if (!empty($telemetria)) {
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'LECTURA DE SONDA (TELEMETRÍA)', 0, 1, 'C');

        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(50, 4, 'DESCRIPCIÓN', 0, 0, 'L');
        $pdf->Cell(30, 4, 'NIVEL (mm)', 0, 0, 'R');
        $pdf->Cell(30, 4, 'VOLUMEN (Gal)', 0, 0, 'R');
        $pdf->Cell(30, 4, 'TEMP (°C)', 0, 1, 'R');
        $pdf->SetFont('helvetica', '', 7);

        foreach ($telemetria as $row) {
            $pdf->Cell(50, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(30, 4, number_format($row['lectura_inicial'] ?? 0, 2), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['lectura_final'] ?? 0, 3), 0, 0, 'R');
            $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
        }
    }

    // --- TOTALES ---
    if (count($totales) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($totales as $row) {
            $pdf->SetX(45);
            if (trim($row['descripcion']) == 'TOTAL DESPACHOS') {
                //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
                imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
                $pdf->Ln(2); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            } else {
            if (trim($row['descripcion'])<>'TOTAL EFECTIVO'){
                    //imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
            $pdf->Cell(57, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->SetTextColor(255,0,0);
                $pdf->Cell(15, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
            }
            }
	        $pdf->SetTextColor(0,0,0);
        }
        //$pdf->Ln(2);
    }

    // --- PAGOS ELECTRONICOS ---
    if (!empty($pagos)) {
        if (!empty($tituloPagos)) {
            $pdf->Ln(2);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->SetX(45);
            $pdf->Cell(0, 4, 'PAGOS ELECTRONICOS', 0, 1, 'L');
            $pdf->Ln(1);
        }
        $pdf->SetFont('helvetica', '', 7);
        foreach ($pagos as $pago) {
        	//imprimirLineaPuntosPequenos($pdf, '- ' . $pago['operacion'], $pago['importe']);
            $pdf->SetX(45);
            $pdf->Cell(57, 4, $pago['operacion'], 0, 0, 'L');
            $pdf->SetTextColor(255,0,0);//Rojo
                $pdf->Cell(15, 4, number_format($pago['importe'] ?? 0, 2), 0, 1, 'R');
            $pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- ENTREGA A BOVEDA ---
    if (count($detalleBoveda) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'ENTREGA A BOVEDA', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleBoveda as $row) {
            $pdf->SetX(45);
            $pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
            $pdf->SetTextColor(255,0,0);//Rojo
                    $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
            $pdf->SetTextColor(0,0,0);//Reset
        }
        //$pdf->Ln(2);
    }

    // --- EGRESOS ---
    if (count($detalleEgresos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'EGRESOS', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleEgresos as $row) {
            $pdf->SetX(45);
            $pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
            $pdf->SetTextColor(255,0,0);//Rojo
            $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
            $pdf->SetTextColor(0,0,0);//Reset
        }
        //$pdf->Ln(2);
    }

    // --- COBRANZA ---
    if (count($detalleCobranza) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'COBRANZA', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleCobranza as $row) {
            $pdf->SetX(45);
        	$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
            $pdf->SetTextColor(0,0,255);//Azul
                    $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
            $pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- INGRESOS ---
    if (count($detalleIngresos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'INGRESOS', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleIngresos as $row) {
            $pdf->SetX(45);
        	$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
            $pdf->SetTextColor(0,0,255);//Azul
                    $pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
            $pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- SALDO FINAL ---
    if (count($porentregar) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($porentregar as $row) {
            //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            $pdf->SetX(45);
            imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
            //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
        }
        $pdf->Ln(4);
    }

    if (!empty($comparativoGalones)) {
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'COMPARACIÓN CONTÓMETRO VS TELEMETRÍA (GALONES)', 0, 1, 'C');
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(45, 4, 'COMBUSTIBLE', 0, 0, 'L');
        $pdf->Cell(30, 4, 'CONTÓMETRO', 0, 0, 'R');
        $pdf->Cell(30, 4, 'TELEMETRÍA', 0, 0, 'R');
        $pdf->Cell(30, 4, 'DIFERENCIA', 0, 1, 'R');
        $pdf->SetFont('helvetica', '', 7);
        foreach ($comparativoGalones as $row) {
            $pdf->Cell(45, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(30, 4, number_format($row['lectura_inicial'], 3), 0, 0, 'R'); // contómetro
            $pdf->Cell(30, 4, number_format($row['lectura_final'], 3), 0, 0, 'R');   // telemetría
            $pdf->Cell(30, 4, number_format($row['importe'], 3), 0, 1, 'R');         // diferencia
        }
    }

    if (!empty($comparativoSoles)) {
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'COMPARACIÓN CONTÓMETRO VS DESPACHOS (SOLES)', 0, 1, 'C');
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(45, 4, '', 0, 0);
        $pdf->Cell(30, 4, 'DESPACHOS', 0, 0, 'R');
        $pdf->Cell(30, 4, 'CONTÓMETRO', 0, 0, 'R');
        $pdf->Cell(30, 4, 'DIFERENCIA', 0, 1, 'R');
        $pdf->SetFont('helvetica', '', 7);
        foreach ($comparativoSoles as $row) {
            $pdf->Cell(45, 4, '', 0, 0);
            $pdf->Cell(30, 4, number_format($row['lectura_inicial'], 2), 0, 0, 'R'); // despachos
            $pdf->Cell(30, 4, number_format($row['lectura_final'], 2), 0, 0, 'R');   // contómetro
            $pdf->Cell(30, 4, number_format($row['importe'], 2), 0, 1, 'R');         // diferencia
        }
    }

    // --- COMPARACIÓN DE LECTURAS ---
    /*if (!empty($comparativo)) {
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(0, 3, '---------------------------------------------------------------------------------------------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Ln(2);
        $pdf->Cell(0, 4, 'COMPARACIÓN DE LECTURAS', 0, 1, 'C');
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($comparativo as $row) {
            $pdf->SetX(25);
            $pdf->Cell(77, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(15, 4, number_format($row['importe'], 2), 0, 1, 'R');
        }
        $pdf->Ln(6);
    }*/

    $pdf->SetFont('helvetica', 'B', $tamFuente);
    $pdf->Cell(0, 4, 'USUARIO: ' . $usuario, 0, 1, 'C');
    $pdf->Ln(2);
    $pdf->Cell(0, 4, 'HORA: ' . $hora, 0, 1, 'C');
    $pdf->Ln(4);
    $pdf->Output('wincha_general.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR capturado: " . $e->getMessage());
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}
?>