<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
        throw new Exception("Parámetros incompletos.");
    }

    $turno_id = (int)$datos[0];
    $nombre_turno = $datos[1];
    $fecha_turno = $datos[2];
    $usuario = $datos[3];

    $sql = "SELECT * FROM liquidacion_turno_por_vendedor(:turno_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([':turno_id' => $turno_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        throw new Exception("No se encontraron datos para el turno.");
    }

    $agrupado = [];
    $resumen = [];
    foreach ($rows as $row) {
        if ($row['categoria'] === 'RESUMEN') {
            $resumen[] = $row;
        } else {
            $agrupado[$row['vendedor_nombre']][] = $row;
        }
    }

    $pdf = new TCPDF('L', 'mm', 'A4', true, 'UTF-8', false);
    $pdf->SetMargins(10, 10, 10);
    $pdf->SetAutoPageBreak(true, 15);
    $pdf->AddPage();

    $pdf->SetFont('helvetica', 'B', 14);
    $pdf->Cell(0, 10, 'LIQUIDACION DE TURNO POR VENDEDOR', 0, 1, 'C');

    $pdf->SetFont('helvetica', '', 10);
    $pdf->Cell(0, 6, "Fecha: $fecha_turno   Turno: $nombre_turno", 0, 1, 'C');
    $pdf->Cell(0, 6, "Usuario: $usuario", 0, 1, 'C');

    foreach ($agrupado as $vendedor => $items) {
        $pdf->Ln(4);
        $pdf->SetFont('helvetica', 'B', 11);
        $pdf->Cell(0, 7, "Vendedor: $vendedor", 0, 1, 'L');

        $pdf->SetFont('helvetica', 'B', 9);
        $pdf->SetFillColor(230, 230, 230);
        $pdf->Cell(40, 7, 'Categoria', 1, 0, 'C', 1);
        $pdf->Cell(40, 7, 'Subcategoria', 1, 0, 'C', 1);
        $pdf->Cell(100, 7, 'Descripcion', 1, 0, 'C', 1);
        $pdf->Cell(30, 7, 'Cantidad', 1, 0, 'C', 1);
        $pdf->Cell(30, 7, 'Importe (S/)', 1, 1, 'C', 1);

        $pdf->SetFont('helvetica', '', 9);
        foreach ($items as $item) {
            $pdf->Cell(40, 6, $item['categoria'], 1);
            $pdf->Cell(40, 6, $item['subcategoria'], 1);
            $pdf->Cell(100, 6, $item['descripcion'], 1);
            $pdf->Cell(30, 6, number_format($item['cantidad'] ?? 0, 3), 1, 0, 'R');
            $pdf->Cell(30, 6, number_format($item['importe'], 2), 1, 1, 'R');
        }
    }

    $pdf->AddPage();
    $pdf->SetFont('helvetica', 'B', 12);
    $pdf->Cell(0, 10, 'RESUMEN GENERAL DEL TURNO', 0, 1, 'C');

    $pdf->SetFont('helvetica', 'B', 9);
    $pdf->Cell(80, 7, 'Descripcion', 1, 0, 'C', 1);
    $pdf->Cell(50, 7, 'Subcategoria', 1, 0, 'C', 1);
    $pdf->Cell(40, 7, 'Importe Total (S/)', 1, 1, 'C', 1);

    $pdf->SetFont('helvetica', '', 9);
    foreach ($resumen as $item) {
        $pdf->Cell(80, 6, $item['descripcion'], 1);
        $pdf->Cell(50, 6, $item['subcategoria'], 1);
        $pdf->Cell(40, 6, number_format($item['importe'], 2), 1, 1, 'R');
    }

    $pdf->Ln(10);
    $pdf->Cell(0, 6, '___________________________', 0, 1, 'L');
    $pdf->Cell(0, 6, 'Firma Responsable', 0, 1, 'L');

    if (ob_get_length()) ob_end_clean();
    ob_clean();
    $pdf->Output('liquidacion_turno_vendedor.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR capturado: " . $e->getMessage());
    http_response_code(500);
    header('Content-Type: application/json; charset=utf-8');
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
    exit;
}
