<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include_once __DIR__ . '/../../conexion.php';
require_once __DIR__ . '/../../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");
//header("Content-Type: text/plain; charset=utf-8");

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7])) {
        throw new Exception("Parámetros incompletos.");
    }

    $turno_id = (int)$datos[0];
    $empleado_id = (int)$datos[1];
    $caja_id = (int)$datos[2];
    $nombre_vendedor = $datos[3] ?? 'Vendedor';
    $nombre_turno = $datos[4] ?? 'MAÑANA';
    $modo = $datos[5] ?? 'vista';
    $fecha_turno = $datos[6];
    $usuario = $datos[7] ?? 'Usuario';

    $sql = "SELECT * FROM wincha_despachos_general(:turno_id, :empleado_id, :caja_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id,
        ':empleado_id' => $empleado_id,
        ':caja_id' => $caja_id
    ]);

    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($resultados)) {
        throw new Exception("No se encontraron registros.");
    }

    $altura_dinamica = calcularAlturaWincha($resultados);
    //$altura_final = ($modo === 'impresion') ? max($altura_dinamica, 1200) : $altura_dinamica;
    $pdf = new TCPDF('P', 'mm', [80, $altura_dinamica], true, 'UTF-8', false);

    $pdf->SetMargins(2, 2, 2);
    $pdf->SetAutoPageBreak(true, 0); // ✔ Ajuste para evitar espacio final excesivo
    $pdf->AddPage();
    $pdf->SetDisplayMode(100, 'SinglePage');

    $logo_path = '../../tcpdf/logos/10278514876.png';
    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }
    $pdf->Ln(18);

    $fecha = date('d/m/Y');
    $hora = date('H:i:s');

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(0, 6, 'W I N C H A', 0, 1, 'C');
    $pdf->Ln(2);

    $tamFuente = ($modo === 'impresion') ? 9 : 8;
    $pdf->SetFont('helvetica', '', $tamFuente);
    $pdf->Cell(0, 5, "Fecha: {$fecha_turno}    Turno: {$nombre_turno}", 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 7);
    $pdf->Cell(0, 5, "VENDEDOR: {$nombre_vendedor}", 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 8);
    //$pdf->Ln(2);

    $lecturasGalones = [];
    $lecturasSoles = [];
    $despachos = [];
    $pagos = [];
    $detalleCobranza = [];
    $detalleIngresos = [];
    $detalleBoveda = [];
    $detalleEgresos = [];
    $totales = [];
    $porentregar = [];
    $tituloPagos = false;

    foreach ($resultados as $row) {
        switch ($row['tipo']) {
            case 'LECTURA_GALONES': $lecturasGalones[] = $row; break;
            case 'LECTURA_SOLES': $lecturasSoles[] = $row; break;
            case 'SUBREPORTE_COMBUSTIBLE': $despachos[] = $row; break;
            case 'DETALLE COBRANZA': $detalleCobranza[] = $row; break;
            case 'DETALLE INGRESOS': $detalleIngresos[] = $row; break;
            case 'DETALLE BOVEDA': $detalleBoveda[] = $row; break;
            case 'DETALLE EGRESOS': $detalleEgresos[] = $row; break;
            case 'VENTAS': $totales[] = $row; break;
            case 'TITULO_PAGO_ELECTRONICO': $tituloPagos = true; break;
            case 'DETALLE_PAGO_ELECTRONICO': $pagos[] = $row; break;
            case 'SALDO FINAL': $porentregar[] = $row; break;
        }
    }

    function imprimirLineaPuntos($pdf, $titulo, $monto) {
        $pdf->Cell(57, 4, $titulo, 0, 0, 'L');
        $pdf->Cell(15, 4, number_format($monto ?? 0, 2), 0, 1, 'R');
    }

    function imprimirLineaPuntosPequenos($pdf, $titulo, $monto) {
        $pdf->Cell(50, 4, $titulo, 0, 0, 'L');
        $pdf->Cell(15, 4, number_format($monto ?? 0, 2), 0, 1, 'R');
    }

    // --- LECTURAS GALONES ---
    if (count($lecturasGalones) > 0) {
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'CONTOMETROS  GALONES', 0, 1, 'C');
    
        $pdf->SetFont('helvetica', '', 7);
        $currentCara = null;
    
        foreach ($lecturasGalones as $row) {
            // Agrupamos por CARA
            if ($row['cara'] !== $currentCara) {
                $currentCara = $row['cara'];
                //$pdf->Ln(1);
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(0, 4, 'CARA ' . $currentCara, 0, 1, 'L');
               /* $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(6, 4, 'M', 0, 0, 'L');
                $pdf->Cell(15, 4, 'COMB', 0, 0, 'L');
                $pdf->Cell(18, 4, 'LFIN', 0, 0, 'C');
                $pdf->Cell(18, 4, 'LINI', 0, 0, 'C');
                $pdf->Cell(18, 4, 'TOTAL', 0, 1, 'C');*/
                $pdf->SetFont('helvetica', '', 7);
            }
    
            $pdf->Cell(6, 4, $row['manguera'], 0, 0, 'L');
            $pdf->Cell(15, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(18, 4, number_format($row['lectura_final'] ?? 0, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($row['lectura_inicial'] ?? 0, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($row['importe'] ?? 0, 3), 0, 1, 'R');
        }
        //$pdf->Ln(2);
    }

    // --- LECTURAS SOLES ---
    if (count($lecturasSoles) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'CONTOMETROS  SOLES', 0, 1, 'C');
    
        $pdf->SetFont('helvetica', '', 7);
        $currentCara = null;
    
        foreach ($lecturasSoles as $row) {
            if ($row['cara'] !== $currentCara) {
                $currentCara = $row['cara'];
                //$pdf->Ln(1);
                $pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(0, 4, 'CARA ' . $currentCara, 0, 1, 'L');
                /*$pdf->SetFont('helvetica', 'B', 7);
                $pdf->Cell(6, 4, 'M', 0, 0, 'L');
                $pdf->Cell(15, 4, 'COMB', 0, 0, 'L');
                $pdf->Cell(18, 4, 'LFIN', 0, 0, 'C');
                $pdf->Cell(18, 4, 'LINI', 0, 0, 'C');
                $pdf->Cell(18, 4, 'TOTAL', 0, 1, 'C');*/
            }
            $pdf->SetFont('helvetica', '', 7);
            $pdf->Cell(6, 4, $row['manguera'], 0, 0, 'L');
            $pdf->Cell(14, 4, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(18, 4, number_format($row['lectura_final'] ?? 0, 2), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($row['lectura_inicial'] ?? 0, 2), 0, 0, 'R');
            $pdf->Cell(17, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
        }
    
        //$pdf->Ln(2);
    }

    // --- DESPACHOS COMBUSTIBLE ---
    if (count($despachos) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'RESUMEN DESPACHOS COMBUSTIBLE', 0, 1, 'C');
    
        $pdf->SetFont('helvetica', 'B', 7);
        $pdf->Cell(22, 4, 'COMBUSTIBLE', 0, 0, 'L');
        $pdf->Cell(18, 4, 'PRECIO', 0, 0, 'C');
        $pdf->Cell(18, 4, 'GALONES', 0, 0, 'C');
        $pdf->Cell(18, 4, 'SOLES', 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 7);

        foreach ($despachos as $row) {
            $descripcion = $row['descripcion'] ?? '-';
            $lectura_inicial = $row['lectura_inicial'] ?? 0;
            $lectura_final = $row['lectura_final'] ?? 0;
            $importe = $row['importe'] ?? 0;

            $pdf->Cell(18, 4, $descripcion, 0, 0, 'L');
            $pdf->Cell(18, 4, number_format($lectura_inicial, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($lectura_final, 3), 0, 0, 'R');
            $pdf->Cell(18, 4, number_format($importe, 2), 0, 1, 'R');
        }
        //$pdf->Ln(2);
    }

    // --- TOTALES ---
    if (count($totales) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($totales as $row) {
            if (trim($row['descripcion']) == 'TOTAL DESPACHOS') {
                //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
                imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
                $pdf->Ln(2); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            } else {
		if (trim($row['descripcion'])<>'TOTAL EFECTIVO'){
                //imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
		$pdf->Cell(57, 4, $row['descripcion'], 0, 0, 'L');
		$pdf->SetTextColor(255,0,0);
	        $pdf->Cell(15, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
		}
            }
	$pdf->SetTextColor(0,0,0);
        }
        //$pdf->Ln(2);
    }

    // --- PAGOS ELECTRONICOS ---
    if (!empty($pagos)) {
        if (!empty($tituloPagos)) {
            $pdf->Ln(2);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(0, 4, 'PAGOS ELECTRONICOS', 0, 1, 'L');
            $pdf->Ln(1);
        }
        $pdf->SetFont('helvetica', '', 7);
        foreach ($pagos as $pago) {
        	//imprimirLineaPuntosPequenos($pdf, '- ' . $pago['operacion'], $pago['importe']);
		$pdf->Cell(57, 4, $pago['operacion'], 0, 0, 'L');
		$pdf->SetTextColor(255,0,0);//Rojo
	        $pdf->Cell(15, 4, number_format($pago['importe'] ?? 0, 2), 0, 1, 'R');
		$pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- ENTREGA A BOVEDA ---
    if (count($detalleBoveda) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'ENTREGA A BOVEDA', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleBoveda as $row) {
		$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
		$pdf->SetTextColor(255,0,0);//Rojo
            	$pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
		$pdf->SetTextColor(0,0,0);//Reset
        }
        //$pdf->Ln(2);
    }

    // --- EGRESOS ---
    if (count($detalleEgresos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'EGRESOS', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleEgresos as $row) {
		$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
		$pdf->SetTextColor(255,0,0);//Rojo
		$pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
		$pdf->SetTextColor(0,0,0);//Reset
        }
        //$pdf->Ln(2);
    }

    // --- COBRANZA ---
    if (count($detalleCobranza) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'COBRANZA', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleCobranza as $row) {
        	$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
		$pdf->SetTextColor(0,0,255);//Azul
            	$pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
		$pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- INGRESOS ---
    if (count($detalleIngresos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 4, 'INGRESOS', 0, 1, 'L');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleIngresos as $row) {
        	$pdf->Cell(42, 4, trim(($row['operacion'] ?? '') . ' ' . ($row['descripcion'] ?? '')), 0, 0, 'L');
		$pdf->SetTextColor(0,0,255);//Azul
            	$pdf->Cell(30, 4, number_format($row['importe'] ?? 0, 2), 0, 1, 'R');
		$pdf->SetTextColor(0,0,0);//Reset Color
        }
        //$pdf->Ln(2);
    }

    // --- SALDO FINAL ---
    if (count($porentregar) > 0) {
        //$pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------------------', 0, 1, 'L');
        //$pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($porentregar as $row) {
            //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
            //$pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
        }
        $pdf->Ln(2);
    }

    $pdf->SetFont('helvetica', 'B', $tamFuente);
    $pdf->Cell(0, 4, 'USUARIO: ' . $usuario, 0, 1, 'C');
    $pdf->Ln(2);
    $pdf->Cell(0, 4, 'HORA: ' . $hora, 0, 1, 'C');
    $pdf->Ln(4);
    $pdf->Output('wincha_general.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR capturado: " . $e->getMessage());
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}

function calcularAlturaWincha(array $resultados): int {
    $lecturasGalones = [];
    $lecturasSoles = [];
    $despachos = [];
    $pagos = [];
    $detalleCobranza = [];
    $detalleIngresos = [];
    $detalleBoveda = [];
    $detalleEgresos = [];
    $totales = [];
    $porentregar = [];
    $tituloPagos = false;

    foreach ($resultados as $row) {
        switch ($row['tipo']) {
            case 'LECTURA_GALONES': $lecturasGalones[] = $row; break;
            case 'LECTURA_SOLES': $lecturasSoles[] = $row; break;
            case 'SUBREPORTE_COMBUSTIBLE': $despachos[] = $row; break;
            case 'DETALLE BOVEDA': $detalleBoveda[] = $row; break;
            case 'DETALLE COBRANZA': $detalleCobranza[] = $row; break;
            case 'DETALLE INGRESOS': $detalleIngresos[] = $row; break;
            case 'DETALLE EGRESOS': $detalleEgresos[] = $row; break;
            case 'VENTAS': $totales[] = $row; break;
            case 'TITULO_PAGO_ELECTRONICO': $tituloPagos = true; break;
            case 'DETALLE_PAGO_ELECTRONICO': $pagos[] = $row; break;
            case 'SALDO FINAL': $porentregar[] = $row; break;
        }
    }

    function alturaLecturas($data) {
        if (empty($data)) return 0;
        $caras = count(array_unique(array_column($data, 'cara')));
        return max(10, ($caras * 10) + (count($data) * 5));
    }

    function alturaDetalle($data) {
        return empty($data) ? 0 : max(10, 10 + (count($data) * 5));
    }

    function alturaTotales($data) {
        return empty($data) ? 0 : max(10, 10 + (count($data) * 5));
    }

    function alturaPorEntregar($data) {
        return empty($data) ? 0 : max(10, 10 + (count($data) * 7));
    }

    $altura_total = 60; // cabecera
    $altura_total += alturaLecturas($lecturasGalones);
    $altura_total += alturaLecturas($lecturasSoles);
    $altura_total += alturaDetalle($despachos);
    $altura_total += alturaDetalle($detalleCobranza);
    $altura_total += alturaDetalle($detalleIngresos);
    $altura_total += alturaDetalle($detalleBoveda);
    $altura_total += alturaDetalle($detalleEgresos);
    $altura_total += alturaDetalle($pagos);
    $altura_total += alturaTotales($totales);
    $altura_total += alturaPorEntregar($porentregar);
    $altura_total += 30; // hora y margen final
    $altura_total += 40; // margen extra preventivo

    return $altura_total;
}

function calcularAlturaWincha_ORIG(array $resultados): int {
    $lecturasGalones = [];
    $lecturasSoles = [];
    $despachos = [];
    $pagos = [];
    $detalleIngresos = [];
    $detalleBoveda = [];
    $detalleEgresos = [];
    $totales = [];
    $porentregar = [];
    $tituloPagos = false;

    foreach ($resultados as $row) {
        switch ($row['tipo']) {
            case 'LECTURA_GALONES': $lecturasGalones[] = $row; break;
            case 'LECTURA_SOLES': $lecturasSoles[] = $row; break;
            case 'SUBREPORTE_COMBUSTIBLE': $despachos[] = $row; break;
            case 'DETALLE INGRESOS': $detalleIngresos[] = $row; break;
            case 'DETALLE BOVEDA': $detalleBoveda[] = $row; break;
            case 'DETALLE EGRESOS': $detalleEgresos[] = $row; break;
            case 'VENTAS': $totales[] = $row; break;
            case 'TITULO_PAGO_ELECTRONICO': $tituloPagos = true; break;
            case 'DETALLE_PAGO_ELECTRONICO': $pagos[] = $row; break;
            case 'SALDO FINAL': $porentregar[] = $row; break;
        }
    }

    // --- FUNCIONES ALTURA ---
    function alturaLecturas($data) {
        $caras = count(array_unique(array_column($data, 'cara')));
        return ($caras * 10) + (count($data) * 5);
    }
    function alturaDetalle($data) {
        return 10 + (count($data) * 5);
    }
    function alturaTotales($data) {
        return 10 + (count($data) * 5);
    }
    function alturaPorEntregar($data) {
        return 10 + (count($data) * 7);
    }

    // --- CALCULAR ALTURA TOTAL ---
    $altura_total = 60; // cabecera
    $altura_total += alturaLecturas($lecturasGalones);
    $altura_total += alturaLecturas($lecturasSoles);
    $altura_total += alturaDetalle($despachos);
    $altura_total += alturaDetalle($detalleCobranza);
    $altura_total += alturaDetalle($detalleIngresos);
    $altura_total += alturaDetalle($detalleBoveda);
    $altura_total += alturaDetalle($detalleEgresos);
    $altura_total += alturaDetalle($pagos);
    $altura_total += alturaTotales($totales);
    $altura_total += alturaPorEntregar($porentregar);
    $altura_total += 30; // hora y margen final

    // Limitar altura máxima (impresoras térmicas)
    // $altura_total = min($altura_total, 1000);

    return $altura_total;
}
?>
