<?php
include_once '../conexion.php'; // Conexión correcta
require_once('../tcpdf/tcpdf.php'); // Librería TCPDF
header("Content-Type: application/pdf");

try {
    // Leer datos recibidos
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos. Se requieren: turno_id, empleado_id, caja_id.");
    }

    $turno_id = (int) $datos[0];
    $empleado_id = (int) $datos[1];
    $caja_id = (int) $datos[2];

    $sql = "SELECT * FROM wincha_despachos_general(:turno_id, :empleado_id, :caja_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id,
        ':empleado_id' => $empleado_id,
        ':caja_id' => $caja_id
    ]);

    $lecturas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($lecturas)) {
        throw new Exception("No se encontraron datos de lecturas.");
    }

    // ⚡ Crear PDF con TCPDF
    $pdf = new TCPDF('P', 'mm', [80, 150], true, 'UTF-8', false);
    $pdf->SetMargins(2, 2, 2);
    $pdf->AddPage();

    // Título
    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(0, 5, 'LECTURAS GALONES', 0, 1, 'C');
    $pdf->Ln(2);

    // Encabezados
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(8, 5, 'CARA', 0, 0);
    $pdf->Cell(10, 5, 'MANG', 0, 0);
    $pdf->Cell(30, 5, 'DESCRIPCION', 0, 0);
    $pdf->Cell(30, 5, 'TOTAL', 0, 1);

    $pdf->Cell(70, 0, str_repeat('-', 70), 0, 1);
    $pdf->Ln(1);

    // Datos
    foreach ($lecturas as $row) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(8, 5, $row['cara'], 0, 0);
        $pdf->Cell(10, 5, $row['manguera'], 0, 0);
        $pdf->Cell(30, 5, $row['descripcion'], 0, 0);
        $pdf->Cell(30, 5, number_format($row['total'], 3), 0, 1, 'R');

        $pdf->SetFont('helvetica', '', 7);
        $linea = 'FINALG ' . number_format($row['finalgalones'], 3) . '  INIG ' . number_format($row['inicialgalones'], 3);
        $pdf->Cell(70, 4, $linea, 0, 1);
        $pdf->Ln(1);
    }

    $pdf->Output('lecturas_galones.pdf', 'I');
} catch (Exception $e) {
    // ⚠️ Si hay error, devolver JSON error
    header("Content-Type: application/json");
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}
?>
