<?php
include_once '../conexion.php';
require_once '../tcpdf/tcpdf.php';

header("Content-Type: application/pdf; charset=utf-8");

try {
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos.");
    }

    error_log("Generando PDF normalmente...");

    $turno_id = (int)$datos[0];
    $empleado_id = (int)$datos[1];
    $caja_id = (int)$datos[2];
    $nombre_vendedor = $datos[3] ?? 'Vendedor';
    $nombre_turno = $datos[4] ?? 'MAÑANA';

    $sql = "SELECT * FROM wincha_despachos_general(:turno_id, :empleado_id, :caja_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id,
        ':empleado_id' => $empleado_id,
        ':caja_id' => $caja_id
    ]);

    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($resultados)) {
        throw new Exception("No se encontraron registros.");
    }

    $pdf = new TCPDF('P', 'mm', [80, 600], true, 'UTF-8', false);
    $pdf->SetMargins(2, 2, 2);
    $pdf->SetAutoPageBreak(true, 2);
    $pdf->AddPage();
    $pdf->SetDisplayMode(100, 'SinglePage');

    // --- Cabecera Logo, Empresa y RUC ---
    $logo_path = '../tcpdf/logos/10278514876.png';
    $razon_social = 'INFOSOLUTIONS PERU SAC';
    $ruc = '20601234567';

    if (file_exists($logo_path)) {
        $pdf->Image($logo_path, '', '', 30, 15, '', '', 'T', false, 300, 'C', false, false, 0, false, false, false);
    }

    $pdf->Ln(18);
    /*$pdf->SetFont('helvetica', 'B', 8);
    $pdf->Cell(0, 5, $razon_social, 0, 1, 'C');
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 5, 'RUC: ' . $ruc, 0, 1, 'C');
    $pdf->Ln(2);*/

    // --- Cabecera WINCHA ---
    $fecha = date('d/m/Y');
    $hora = date('H:i:s');

    $pdf->SetFont('helvetica', 'B', 10);
    $pdf->Cell(0, 6, 'W I N C H A', 0, 1, 'C');
    $pdf->Ln(2);
    $pdf->SetFont('helvetica', '', 8);
    $pdf->Cell(0, 5, "Fecha: {$fecha}    Turno: {$nombre_turno}", 0, 1, 'C');
    $pdf->Cell(0, 5, "VENDEDOR: {$nombre_vendedor}", 0, 1, 'C');
    $pdf->Ln(2);

    // --- Clasificar datos ---
    $lecturasGalones = [];
    $lecturasSoles = [];
    $despachos = [];
    $pagos = [];
    $detalleBoveda = [];
    $detalleEgresos = [];
    $totales = [];

    foreach ($resultados as $row) {
        switch ($row['tipo']) {
            case 'LECTURA_GALONES':
                $lecturasGalones[] = $row;
                break;
            case 'LECTURA_SOLES':
                $lecturasSoles[] = $row;
                break;
            case 'SUBREPORTE_COMBUSTIBLE':
                $despachos[] = $row;
                break;
            case 'DETALLE BOVEDA':
                $detalleBoveda[] = $row;
                break;
            case 'DETALLE EGRESOS':
                $detalleEgresos[] = $row;
                break;
            case 'VENTAS':
                $totales[] = $row;
                break;
            case 'TITULO_PAGO_ELECTRONICO':
                $tituloPagos = true;  // bandera para imprimir el título
                break;
            case 'DETALLE_PAGO_ELECTRONICO':
                $pagos[] = $row;
                break;    
            case 'SALDO FINAL':
                $porentregar[] = $row;
                break;     
        }
    }

    // --- Función para puntos ---
    function imprimirLineaPuntos($pdf, $titulo, $monto)
    {
        $anchoPagina = 80; // El ancho de tu ticket (en mm)
        $anchoTitulo = 50; // Ancho para el título + puntos
        $anchoMonto = 15;  // Ancho para el monto
    
        // Armamos el título con puntos
        $tituloConPuntos = str_pad($titulo, $anchoTitulo, '.', STR_PAD_RIGHT);
    
        // Título con puntos
        $pdf->Cell($anchoTitulo, 5, $titulo, 0, 0, 'L');
        // Monto a la derecha
        $pdf->Cell($anchoMonto, 5, number_format($monto, 2), 0, 1, 'R');
    }
    

    // --- LECTURAS GALONES ---
    if (count($lecturasGalones) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 5, 'LECTURAS GALONES', 0, 1, 'C');
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(0, 5, 'CARA  MANG  DESCRIPCION                          TOTAL', 0, 1, 'L');
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------', 0, 1, 'L');

        foreach ($lecturasGalones as $row) {
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(10, 5, $row['cara'], 0, 0, 'L');
            $pdf->Cell(10, 5, $row['manguera'], 0, 0, 'L');
            $pdf->Cell(60, 5, $row['descripcion'], 0, 1, 'L');

            $pdf->SetFont('helvetica', '', 7);
            $lecturaFinal = number_format($row['lectura_final'], 3);
            $lecturaInicial = number_format($row['lectura_inicial'], 3);
            $totalGalones = number_format($row['importe'], 3);

            $pdf->Cell(50, 3, 
                'L.FIN : ' . $lecturaFinal . 
                '   L.INI : ' . $lecturaInicial, 
            0, 0, 'L');

            $pdf->Cell(15, 3, $totalGalones, 0, 1, 'R');
        }
        $pdf->Ln(2);
    }

    // --- LECTURAS SOLES ---
    if (count($lecturasSoles) > 0) {
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 5, 'LECTURAS SOLES', 0, 1, 'C');
        $pdf->SetFont('helvetica', '', 7);
        $pdf->Cell(0, 5, 'CARA  MANG  DESCRIPCION                          TOTAL', 0, 1, 'L');
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------', 0, 1, 'L');

        foreach ($lecturasSoles as $row) {
            $pdf->SetFont('helvetica', 'B', 7);
            $pdf->Cell(10, 5, $row['cara'], 0, 0, 'L');
            $pdf->Cell(10, 5, $row['manguera'], 0, 0, 'L');
            $pdf->Cell(60, 5, $row['descripcion'], 0, 1, 'L');

            $pdf->SetFont('helvetica', '', 7);
            $lecturaFinal = number_format($row['lectura_final'], 3);
            $lecturaInicial = number_format($row['lectura_inicial'], 3);
            $totalSoles = number_format($row['importe'], 3);

            $pdf->Cell(50, 3, 
                'L.FIN : ' . $lecturaFinal . 
                '   L.INI : ' . $lecturaInicial, 
            0, 0, 'L');

            $pdf->Cell(15, 3, $totalSoles, 0, 1, 'R');
        }
        $pdf->Ln(2);
    }

    // --- DESPACHOS COMBUSTIBLE ---
    if (count($despachos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 5, 'COMBUSTIBLE    PRECIO    GALONES   SOLES', 0, 1, 'L');
        $pdf->Cell(0, 3, '-------------------------------------------', 0, 1, 'L');
        $pdf->SetFont('helvetica', '', 7);
        foreach ($despachos as $row) {
            $pdf->Cell(20, 5, $row['operacion'], 0, 0, 'L');
            $pdf->Cell(15, 5, $row['descripcion'], 0, 0, 'L');
            $pdf->Cell(20, 5, number_format($row['importe'], 2), 0, 1, 'R');
        }
        $pdf->Ln(2);
    }

    // --- TOTALES ---
    if (count($totales) > 0) {
        $pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($totales as $row) {
            if (trim($row['descripcion']) == 'TOTAL DESPACHOS') {
                $pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
                imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
                $pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            } else {
                imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
            }
        }
        $pdf->Ln(2);
    }

    // --- PAGOS ELECTRONICOS ---
    if (!empty($pagos)) {
        if (!empty($tituloPagos)) {
            $pdf->Ln(2);
            $pdf->SetFont('helvetica', 'B', 8);
            $pdf->Cell(0, 5, 'PAGOS ELECTRONICOS', 0, 1, 'C');
            $pdf->Ln(1);
        }
        $pdf->SetFont('helvetica', '', 7);
        foreach ($pagos as $pago) {
            imprimirLineaPuntosPequenos($pdf, '- ' . $pago['operacion'], $pago['importe']);
        }
        $pdf->Ln(2);
    }

    // --- ENTREGA A BOVEDA ---
    if (count($detalleBoveda) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 5, 'ENTREGA A BOVEDA', 0, 1, 'C');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleBoveda as $row) {
            $pdf->Cell(40, 5, $row['operacion'], 0, 0, 'L');
            $pdf->Cell(30, 5, number_format($row['importe'], 2), 0, 1, 'R');
        }
        $pdf->Ln(2);
    }

    // --- EGRESOS ---
    if (count($detalleEgresos) > 0) {
        $pdf->SetFont('helvetica', 'B', 8);
        $pdf->Cell(0, 5, 'EGRESOS', 0, 1, 'C');
        $pdf->Ln(1);
        $pdf->SetFont('helvetica', '', 7);
        foreach ($detalleEgresos as $row) {
            $pdf->Cell(40, 5, $row['operacion'], 0, 0, 'L');
            $pdf->Cell(30, 5, number_format($row['importe'], 2), 0, 1, 'R');
        }
        $pdf->Ln(2);
    }

    // --- SALDO FINAL ---
    if (count($porentregar) > 0) {
        $pdf->Ln(2);
        $pdf->Cell(0, 3, '-----------------------------------------------------------------------------', 0, 1, 'L');
        $pdf->Ln(2);
        $pdf->SetFont('helvetica', 'B', 8);
        foreach ($porentregar as $row) {
            $pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
            imprimirLineaPuntos($pdf, $row['descripcion'], $row['importe']);
            $pdf->Ln(4); // 🔥 Esto genera dos saltos (cada salto es 2mm, 4=dos saltos)
        }
        $pdf->Ln(2);
    }

    // --- Hora Final ---
    $pdf->SetFont('helvetica', 'B', 8);
    $pdf->Cell(0, 5, 'HORA: ' . $hora, 0, 1, 'C');

    $pdf->Output('wincha_general.pdf', 'I');

} catch (Exception $e) {
    error_log("ERROR capturado: " . $e->getMessage());
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}

function imprimirLineaPuntosPequenos($pdf, $titulo, $monto)
{
    $anchoPagina = 80; // El ancho de tu ticket (en mm)
        $anchoTitulo = 50; // Ancho para el título + puntos
        $anchoMonto = 15;  // Ancho para el monto
    
        // Armamos el título con puntos
        $tituloConPuntos = str_pad($titulo, $anchoTitulo, '.', STR_PAD_RIGHT);
    
        // Título con puntos
        $pdf->Cell($anchoTitulo, 5, $titulo, 0, 0, 'L');
        // Monto a la derecha
        $pdf->Cell($anchoMonto, 5, number_format($monto, 2), 0, 1, 'R');
}
?>
