<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar sesión/token
$usuarioId = TokenValidator::validar($conn);

// Leer y decodificar el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar JSON
if (json_last_error() !== JSON_ERROR_NONE) {
    http_response_code(400);
    echo json_encode(['ESTADO' => '0', 'MENSAJE' => '❌ JSON inválido']);
    exit();
}

// Validar cantidad de parámetros
if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4], $datos[5], $datos[6], $datos[7])) {
    http_response_code(400);
    echo json_encode(['ESTADO' => '0', 'MENSAJE' => '❌ Parámetros incompletos']);
    exit();
}

// Asignar y sanitizar parámetros
$p_nombre        = trim($datos[0]);
$p_descripcion   = trim($datos[1]);
$p_cuenta_id     = (int) $datos[2];
$p_afectawincha  = filter_var($datos[3], FILTER_VALIDATE_BOOLEAN);
$p_empresa_id    = (int) $datos[4];
$p_sucursal_id   = (int) $datos[5];
$p_idtipo_pago   = (int) $datos[6];
$p_estado        = strtoupper(trim($datos[7]));

try {
    // Llamada a la función PostgreSQL
    $sql = "SELECT im_tipopago(:nombre, :descripcion, :p_cuenta_id, :afectawincha, :empresa_id, :sucursal_id, :idtipo_pago, :estado) AS id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':nombre', $p_nombre, PDO::PARAM_STR);
    $stmt->bindParam(':descripcion', $p_descripcion, PDO::PARAM_STR);
    $stmt->bindParam(':p_cuenta_id', $p_cuenta_id, PDO::PARAM_INT);
    $stmt->bindParam(':afectawincha', $p_afectawincha, PDO::PARAM_BOOL);
    $stmt->bindParam(':empresa_id', $p_empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $p_sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':idtipo_pago', $p_idtipo_pago, PDO::PARAM_INT);
    $stmt->bindParam(':estado', $p_estado, PDO::PARAM_STR);
    $stmt->execute();

    // Obtener ID de la operación
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $id = $result['id'];

    if ($id > 0) {
        $mensaje = ($p_estado === 'NUEVO') 
            ? 'LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE' 
            : 'LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE';

        echo json_encode([
            'ESTADO'  => '1',
            'ID'      => $id,
            'MENSAJE' => '✅ ' . $mensaje
        ], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode([
            'ESTADO'  => '0',
            'ID'      => '0',
            'MENSAJE' => '❌ No se guardaron los datos'
        ], JSON_UNESCAPED_UNICODE);
    }

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'ESTADO'  => '0',
        'ID'      => '0',
        'MENSAJE' => '❌ Error en la base de datos: ' . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
}
