<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 7) {
        throw new Exception("Parámetros incompletos. Se requieren 6 datos.");
    }

    $sql = "SELECT * FROM im_transportista(:ctipdoc, :cdocidentidad, :cnombre, :cdireccion, :cempresa_id, :nidtransp, :cestado) AS id_transportista";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':ctipdoc', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':cdocidentidad', $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':cnombre', $datos[2], PDO::PARAM_STR);
    $stmt->bindValue(':cdireccion', $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':cempresa_id', $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':nidtransp', $datos[5], PDO::PARAM_INT);
    $stmt->bindValue(':cestado', $datos[6], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[6] === "NUEVO") {
        if ($result && isset($result['id_transportista']) && $result['id_transportista'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id_transportista'],
                "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else {
        // Para "MODIFICAR" (devuelve siempre el id aunque no lo uses)
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $result['id_transportista'] ?? "0",
            "MENSAJE" => "LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}