<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 6) {
        throw new Exception("Parámetros incompletos. Se requieren 6 datos.");
    }

    $sql = "SELECT * FROM im_turno(
        CAST(:nombre AS VARCHAR),
        CAST(:activo AS BOOLEAN),
        CAST(:empresa_id AS INTEGER),
        CAST(:sucursal_id AS INTEGER),
        CAST(:id AS INTEGER),
        CAST(:estado AS VARCHAR)
    ) AS id";
    
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':nombre', $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':activo', $datos[1], PDO::PARAM_BOOL);
    $stmt->bindValue(':empresa_id', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $datos[3], PDO::PARAM_INT);
    $stmt->bindValue(':id', $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $datos[5], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[5] === "NUEVO") {
        if ($result && isset($result['id']) && $result['id'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id'],
                "MENSAJE" => "TURNO GUARDADO CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR EL TURNO"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => strval($datos[4]),
            "MENSAJE" => "TURNO ACTUALIZADO CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
