<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación básica
    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros insuficientes.");
    }

    $ventaId = (int)$datos[0];
    $tipodoc = (int)$datos[1];
    $almacenId = (int)$datos[2];

    // Llamar a la función PostgreSQL
    $sql = "SELECT * FROM Listar_DetVentaItem(:ventaId, :tipodoc, :almacenId)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':ventaId', $ventaId, PDO::PARAM_INT);
    $stmt->bindValue(':tipodoc', $tipodoc, PDO::PARAM_INT);
    $stmt->bindValue(':almacenId', $almacenId, PDO::PARAM_INT);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Respuesta estándar
    echo json_encode([
        "estado" => "00",
        "mensaje" => "OK",
        "data" => $rows
    ], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "estado" => "99",
        "error" => "Error en la API",
        "mensaje" => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>