<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 2) {
        throw new Exception("Datos incompletos");
    }

    $clasificacion1 = $datos[0];
    $clasificacion2 = $datos[1];

    $sql = "SELECT * FROM docfiscales WHERE clasificacion = :clas1 OR clasificacion = :clas2 ORDER BY nombre";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':clas1', $clasificacion1);
    $stmt->bindParam(':clas2', $clasificacion2);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    error_response("Error en base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
